# -*- coding: utf-8 -*-
from setuphelpers import *
import bs4 as BeautifulSoup


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://www.uvnc.com/downloads/ultravnc.html"
    if control.architecture == "x64":
        bin_ends = "_x64_Setup.exe"
    else:
        bin_ends = "_x86_Setup.exe"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "span", "style", "font-size: 14pt;", proxies=proxies):
        if 'development' in bs_search.text:
            continue
        version = bs_search.text.split(':')[-1].split(" ")[-1].strip()
        break
    # https://www.uvnc.eu/download/1400/UltraVNC_1_4_05_X64_Setup.exe
    download_url = (
        "https://www.uvnc.eu/download/"
        + version.replace(".", "")
        + "/UltraVNC_"
        + version.replace(".", "")
        + bin_ends
    )
    latest_bin = download_url.split("/")[-1]

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin, "FileVersion")
    # if not version_from_file.startswith(version) and version_from_file != '':
    if Version(version_from_file) != Version(version) and version_from_file != "":
        print("Changing version to the version number of the binary (from: %s to: %s)" % (version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return result
