# -*- coding: utf-8 -*-
from setuphelpers import *

bin_path = makepath("/", "usr", "local", "bin")
app_path = "/opt/typst"

def install():
    # Extraction and copying to /opt/typst
    extract_path = glob.glob("*.tar.xz")[0]
    run(f"tar -xJvf {extract_path}")
    char_len = len(extract_path) - len('.tar.xz')
    extract_path = extract_path[:char_len]
    bin_name = glob.glob(extract_path)[0]
    print(f"copying typst to {app_path}")
    if not isdir(app_path):
        mkdirs(app_path)
    copytree2(bin_name, app_path)
    
    # Creation symlink
    symlink_path = f"{bin_path}/typst"
    if isfile(symlink_path) or os.path.islink(symlink_path):
        print("Symlink already exists, removing it")
        os.remove(symlink_path)
    
    print("create typst alias in path")
    os.symlink(f"{app_path}/typst", symlink_path)
    
    if isdir(extract_path):
        remove_tree(extract_path)

    

def uninstall():
    # Removing of symlink
    if isfile(f"{bin_path}/typst"):
        remove_file(f"{bin_path}/typst")
    # Removing of the software 
    if isdir(app_path):
        remove_tree(app_path)