# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_contains = "tSIP"
app_name = "tSIP"
app_dir = makepath(programfiles32, app_name)
app_path = makepath(app_dir, "tSIP.exe")


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*%s*.zip" % bin_contains)[0]

    # Getting installed software version
    if isfile(app_path):
        if installed_softwares(name=app_name):
            for installed_app in installed_softwares(name=app_name):
                installed_version = installed_app["version"]
                break
        else:
            installed_version = get_version_from_binary(app_path)
    else:
        installed_version = None

    # Installing software
    print("Installing: %s" % app_name)
    if installed_version is None or Version(installed_version) < Version(package_version) or force:
        killalltasks(control.get_impacted_process_list())
        if isdir(app_dir):
            remove_tree(app_dir)
        mkdirs(app_dir)
        print("Extracting: %s to: %s" % (bin_name, app_dir))
        unzip(bin_name, ".")
        temp_dir = bin_name.rsplit(".", 1)[0]
        for file_to_move in glob.glob("%s/*" % temp_dir):
            shutil.move(file_to_move, app_dir)
        remove_tree(temp_dir)

        # Creating shortcuts
        icon_path = app_path
        create_desktop_shortcut(app_name, app_path, icon=icon_path)
        create_programs_menu_shortcut(app_name, app_path, icon=icon_path)

        # Adding software to "list-registry"
        print("Registering: %s to Windows Registry" % app_name)
        register_windows_uninstall(control, win64app=iswin64())
        register_uninstall(app_name, win64app=iswin64(), icon=icon_path)
    else:
        print("%s is already installed. Skipping" % app_name)


def uninstall():
    # Uninstalling software
    killalltasks(control.get_impacted_process_list())
    if isdir(app_dir):
        remove_tree(app_dir)
    unregister_uninstall(app_name, win64app=iswin64())

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)


def audit():
    # Declaring local variables
    package_version = control.get_software_version()
    installed_version = None

    # Getting installed software version
    for installed_app in installed_softwares(name=app_name):
        installed_version = installed_app["version"]
        break

    # Auditing software
    print("Auditing: %s" % control.package)
    if installed_version is None:
        print("%s is not installed" % app_name)
        return "ERROR"
    elif Version(installed_version) != Version(package_version):
        print("%s is installed in version (%s) instead of (%s)" % (app_name, installed_version, package_version))
        return "WARNING"
    else:
        print("%s is installed in correct version (%s)" % (app_name, installed_version))
        return "OK"
