# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import requests


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    download_url = "https://trillian.im/get/windows/msi/"

    # Getting latest version information from download url
    requests_result = requests.head(download_url, proxies=proxies, allow_redirects=True)
    latest_bin = requests_result.url.split("/")[-1]

    # Deleting binaries
    for f in glob.glob('*.msi'):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)

    latest_version = get_msi_properties(latest_bin)["ProductVersion"]

    # Updating the package
    control.set_software_version(latest_version)
    control.save_control_to_wapt()

    return package_updated
