# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name = glob.glob('Tribler_*.exe')[0]
    software_version = control.get_software_version()

    # Uninstalling older major versions of the software
    for to_uninstall in installed_softwares(name="Tribler"):
        if Version(to_uninstall["version"], 3) < Version(software_version, 3) or force:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(control.impacted_process.split(","))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])

    # Installing the software
    install_exe_if_needed(bin_name,
        silentflags='/S /allusers',
        key='Tribler',
        min_version=control.get_software_version(),
    )



