# -*- coding: utf-8 -*-
from setuphelpers import *
import re


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    dict_arch = {
        "x64" :"windows.x86_64.zip"
    }
    git_repo = "tilt-dev/tilt"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))
    for download in json_load["assets"]:
        if download["browser_download_url"].endswith(".zip") and dict_arch[control.architecture] in download["browser_download_url"] :
            url_dl = download["browser_download_url"]
            version = json_load["tag_name"].replace("v","")
            filename = download["name"]
            break

    if not isfile(filename):
        package_updated = True
        wget(url_dl, filename, proxies=proxies)

    # nettoyer les fichiers temporaires
    for f in glob.glob("*.zip"):
        if f != filename:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()
