# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
import re


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/TB-throwback/LookOut-fix-version/releases/latest"

    # Get data from API
    releases_dict = json.loads(wgets(api_url, proxies=proxies))
    version = releases_dict["name"].split(" ")[-1]
    exe_found = False  # Flag pour indiquer la découverte d'un fichier .exe
    for release in releases_dict:
        if exe_found:
            break
        for asset in releases_dict["assets"]:
            if asset["browser_download_url"].endswith(".xpi"):
                url_download = asset["browser_download_url"]
                latest_bin = url_download.split("/")[-1]
                exe_found = True  # Mettre à jour le flag pour indiquer qu'un exe a été trouvé
                break

    # Deleting binaries
    for f in glob.glob("*.xpi"):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % url_download)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_download, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()
