# -*- coding: utf-8 -*-
from setuphelpers import *
import json
import glob

thunderbird_dir = installed_softwares('thunderbird')[0]['install_location']
policies_file = makepath(thunderbird_dir,'distribution','policies.json')
plugins_dir = makepath(thunderbird_dir,"plugins")

extension_key = "lookout@s3_fix_version"
xpi_name = "lookout_fix_version-*-tb.xpi"

def install():
    version = control.version.split('-')[0]
    for filename in glob.glob(xpi_name):
        xpi = filename

    extension_parameters = {extension_key:{"installation_mode": "force_installed","install_url":"file://" + makepath(thunderbird_dir,"plugins",xpi)}}

    print('Copy plugin')
    if not isdir(plugins_dir):
        mkdirs(plugins_dir)

    for old_ext in glob.glob(makepath(plugins_dir,xpi_name)):
        remove_file(old_ext)

    filecopyto(xpi,plugins_dir)

    if not isfile(policies_file):
        print('Create empty policies.json')
        mkdirs(makepath(thunderbird_dir,'distribution'))
        with open(policies_file,'w') as new_policies:
            new_policies.write(json.dumps({'policies':{}}))

    print('Update policies.json')
    with open(policies_file) as policies:
        conf = json.load(policies)

    if 'ExtensionSettings' in conf['policies']:
        extensions = conf['policies']['ExtensionSettings']
        extensions.update(extension_parameters)
        conf['policies']['ExtensionSettings'] = extensions
    else:
        # add extension
        conf['policies']['ExtensionSettings'] = extension_parameters

    with open(policies_file,'w') as new_policies:
        json.dump(conf, new_policies,
            indent=4,
            separators=(',',': '))


def uninstall():

    print('Remove plugin to policies.json')
    with open(policies_file) as policies:
        conf = json.load(policies)

    extensions = conf['policies']['ExtensionSettings']
    extensions.pop(extension_key)
    conf['policies']['ExtensionSettings'] = extensions

    with open(policies_file,'w') as new_policies:
        json.dump(conf, new_policies,
            indent=4,
            separators=(',',': '))

    print('Remove plugin in dir')

    for filename in glob.glob(xpi_name):
        remove_file(makepath(plugins_dir,filename))
