# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    #they do not always release versions for all platforms
    url = 'https://thorium.edrlab.org/en'

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", proxies=proxies):
        if 'amd64.deb' in bs_search['href']:
            download_url = bs_search["href"]
            latest_bin = download_url.split("/")[-1]
            version = latest_bin.split("_")[1]
            break

       # Deleting binaries
    for f in glob.glob("*.dmg"):
        print("Removing: %s" % f)
        remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package

    print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
    package_updated = True
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated