# -*- coding: utf-8 -*-
from setuphelpers import *


app_name = "Text-Grab"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir, f"{app_name}.exe")


def install():


    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)

    unzipped_dir = glob.glob("Text-Grab-Self-Contained")[0]
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)

    # Creating custom shortcuts
    create_programs_menu_shortcut(app_name, target=app_path)


def uninstall():
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    remove_programs_menu_shortcut(app_name)
