# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import os
r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

app_path = makepath(programfiles, 'test-compta-demat')
app_exe = makepath(app_path,'testeur', 'testeur.bat')
nameshortcut = "Test-Compta-Demat"

def install():

    bin_name = glob.glob("Test*.exe")[0]
    unzip_with_7zip(bin_name, app_path)

    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_path) and force:
        remove_tree(app_path)
    mkdirs(app_path)
    print("Extracting: %s to: %s" % (bin_name, app_path))
    unzip_with_7zip(bin_name, app_path)

    if isdir(app_path):
        # Nettoyage des anciennes ACL pour le groupe Authenticated Users (S-1-5-11)
        run(r'icacls "{}" /remove "*S-1-5-11" /T /C'.format(app_path))
        # Puis on redonne "Full Control" au groupe Authenticated Users (S-1-5-11)
        run(r'icacls "{}" /grant "*S-1-5-11:(OI)(CI)(F)" /T /C'.format(app_path))

    # Creating custom shortcuts
    create_programs_menu_shortcut(nameshortcut, target=app_exe, wDir=os.path.dirname(app_exe))

def audit():
    if isfile(makepath(app_exe)):
        print(f"Le fichier {app_exe} est bien présent.")
        return "OK"
    else:
        return "ERROR"

def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_path):
        remove_tree(app_path)

    # Removing shortcuts
    remove_programs_menu_shortcut(nameshortcut)