# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/Eugeny/tabby/releases/latest"
    os_dict = {"windows": "setup-x64.exe", "debian_based": "-linux-x64.deb", "redhat_based": "-linux-x64.rpm", "darwin": "-macos-x86_64.pkg"}
    arch_dict = {"x64": "setup-x64.exe", "x86": "win32.exe"}

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for to_download in json_load["assets"]:
        key = control.target_os.split(",")[1].strip("(>=10)") + "_based"
        if os_dict[key] in to_download["name"]:
            download_url = to_download["browser_download_url"]
            version = json_load["tag_name"].split("-")[-1].replace("v", "")
            latest_bin = to_download["name"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating update-package-sources
    return package_updated
