/// <reference types="node" />
import { PartialProfile } from 'tabby-core';
import { SSHProfileImporter, SSHProfile, AutoPrivateKeyLocator } from 'tabby-ssh';
import { ElectronService } from './services/electron.service';
export declare class OpenSSHImporter extends SSHProfileImporter {
    getProfiles(): Promise<PartialProfile<SSHProfile>[]>;
}
export declare class StaticFileImporter extends SSHProfileImporter {
    private configPath;
    constructor(electron: ElectronService);
    getProfiles(): Promise<PartialProfile<SSHProfile>[]>;
}
export declare class PrivateKeyLocator extends AutoPrivateKeyLocator {
    getKeys(): Promise<[string, Buffer][]>;
}
