import { Observable, Subject } from 'rxjs';
import { Injector } from '@angular/core';
import { Logger } from '../services/log.service';
export declare enum Platform {
    Linux = "Linux",
    macOS = "macOS",
    Windows = "Windows",
    Web = "Web"
}
/**
 * Provides interaction with the main process
 */
export declare abstract class HostAppService {
    abstract get platform(): Platform;
    abstract get configPlatform(): Platform;
    protected settingsUIRequest: Subject<void>;
    protected configChangeBroadcast: Subject<void>;
    protected logger: Logger;
    /**
     * Fired when Preferences is selected in the macOS menu
     */
    get settingsUIRequest$(): Observable<void>;
    /**
     * Fired when another window modified the config file
     */
    get configChangeBroadcast$(): Observable<void>;
    constructor(injector: Injector);
    abstract newWindow(): void;
    emitReady(): void;
    abstract relaunch(): void;
    abstract quit(): void;
}
