"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = exports.NewChannel = void 0;
const rxjs_1 = require("rxjs");
const helpers_1 = require("./helpers");
class NewChannel {
    constructor(inner) {
        this.inner = inner;
    }
    take() {
        if (this.inner === null) {
            throw new Error('Channel already taken');
        }
        const inner = this.inner;
        this.inner = null;
        return inner;
    }
}
exports.NewChannel = NewChannel;
class Channel extends helpers_1.Destructible {
    constructor(id, inner, events) {
        super();
        this.id = id;
        this.inner = inner;
        this.data$ = events.data$.pipe((0, rxjs_1.filter)(([channel]) => channel === id), (0, rxjs_1.map)(([_, data]) => data));
        this.extendedData$ = events.extendedData$.pipe((0, rxjs_1.filter)(([channel]) => channel === id), (0, rxjs_1.map)(([_, ext, data]) => [ext, data]));
        this.eof$ = events.eof$.pipe((0, rxjs_1.filter)(channel => channel === id), (0, rxjs_1.map)(() => { }));
        this.closed$ = events.close$.pipe((0, rxjs_1.filter)(channel => channel === id), (0, rxjs_1.map)(() => { }));
    }
    take() {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            this.destruct();
            return this.inner;
        });
    }
    requestShell() {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.requestShell();
        });
    }
    requestExec(command) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.requestExec(command);
        });
    }
    requestAgentForwarding() {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.requestAgentForwarding();
        });
    }
    requestPTY(terminal, opts) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.requestPty(terminal, opts.columns, opts.rows, opts.pixWidth, opts.pixHeight);
        });
    }
    requestX11Forwarding(options) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.requestX11Forwarding(options.singleConnection, options.authProtocol, options.authCookie, options.screenNumber);
        });
    }
    resizePTY(size) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.windowChange(size.columns, size.rows, size.pixWidth, size.pixHeight);
        });
    }
    write(data) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.data(data);
        });
    }
    eof() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.inner.eof();
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.inner.close();
        });
    }
}
exports.Channel = Channel;
