# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"synfigstudio",
   "name":"Synfig Studio (64bit)",
   "version":"1.4.5-f4b8d",
   "install_date":"",
   "install_location":"",
   "uninstall_string":"\"C:\\Program Files\\Synfig\\uninstall-synfigstudio.exe\"",
   "publisher":"",
   "system_component":0,
   "win64":true
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name= glob.glob("SynfigStudio-*-win64-*.exe")[0]

    # Uninstalling other versions of the software
    for to_uninstall in installed_softwares("synfigstudio"):
        if Version(to_uninstall["version"]) != Version(control.get_software_version()) or force:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            try:
                killalltasks(ensure_list(control.impacted_process))
                quiet_uninstall_string = (installed_softwares(uninstallkey=to_uninstall["key"])[0]["uninstall_string"] + r'/S')
                run(quiet_uninstall_string)
                wait_uninstallkey_absent(to_uninstall["key"])
            except Exception as e: 
                print(e)
                print("Remove failed: %s (%s)\nContinuing..." % (to_uninstall["name"], to_uninstall["version"]))

    # Installing the software
    
    install_exe_if_needed(bin_name,
        silentflags='/S',
        key='synfigstudio',
        min_version= control.get_software_version(),
        get_version=get_version,
        timeout=900,
    )


def get_version(app_registry_dict):

    return app_registry_dict["version"].split("-")[0]
    
