# -*- coding: utf-8 -*-
from setuphelpers import *
import sys
sys.path.append('/opt/wapt')
import tempfile
import json
from common import get_requests_client_cert_session
from common import Wapt
from waptpackage import WaptRemoteRepo
import waptlicences
from waptutils import FileChunks
from setuphelpers import wget,isfile,makepath,remove_file
from waptutils import sha256_for_file,sha256_for_data
import copy
import os
import platform


def install():


    confjson = makepath(WAPT.private_dir,'sync-waptserver-conf.json')
    if not isfile(confjson):
        filecopyto('sync-waptserver-conf.json.template',confjson)

def audit():

    conf_file =  makepath(WAPT.private_dir,'sync-waptserver-conf.json')

    with open(conf_file,'r') as f:
        datajson = json.loads(f.read())

    runync(datajson)

    return "OK"

class RunSynchro():

    def __init__(self, waptgetiniremote=None,waptgetinisource=None, username_remote=None,password_remote=None,username_source=None,password_source=None,prefix="",tmpdir=None,sessionwaptsource=None,wsource=None,source_repo=None,wapt_url_source=None):

        self.tmpdir = tmpdir
        self.wremote = Wapt(config_filename=waptgetiniremote)


        password_remote = password_remote + '#'
        t = waptlicences.waptserver_login(waptgetiniremote,username_remote,password_remote[:-1])
        if not 'session' in t['session_cookies']:
            session_cookies = [u for u in t['session_cookies'] if u['Domain'] == self.wremote.waptserver.server_url.split('://')[-1]][0]
        else:
            session_cookies = t['session_cookies']['session']
            session_cookies['Name'] = 'session'
        self.wapt_url_remote = self.wremote.waptserver.server_url
        self.remote_repo = WaptRemoteRepo(url=self.wremote.waptserver.server_url + '/wapt', verify_cert=self.wremote.waptserver.verify_cert)

        self.sessionwaptremote = get_requests_client_cert_session(self.wremote.waptserver.server_url,cert=(t['client_certificate'],t['client_private_key'],t['client_private_key_password']),verify=self.wremote.waptserver.verify_cert)
        self.sessionwaptremote.cookies.set(session_cookies['Name'], session_cookies['Value'], domain=session_cookies['Domain'])
        self.sessionwaptremote.verify = self.wremote.waptserver.verify_cert

        self.remote_repo.client_certificate  = t['client_certificate']
        self.remote_repo.client_private_key  = t["client_private_key"]
        self.remote_client_private_key_password     = t["client_private_key_password"]
        self.prefix = prefix.lower()

        def give_password_remote(location=None,identity=None):
            return self.remote_client_private_key_password

        self.remote_repo.private_key_password_callback = give_password_remote
        self.source_repo = source_repo
        self.sessionwaptsource = sessionwaptsource
        self.wapt_url_source = wapt_url_source


    def get_missing_package(self):
        dict_missing_package = []
        locrepodict    = {g.package_uuid : g for g in self.source_repo.packages() if g.package.lower().startswith(self.prefix) and not 'waptupgrade' in g.package.lower()}
        remoterepodict = {g.package_uuid : g for g in self.remote_repo.packages() if g.package.lower().startswith(self.prefix) and not 'waptupgrade' in g.package.lower()}

        for u in locrepodict :
            if not u in remoterepodict :
                dict_missing_package.append(locrepodict[u])
        return dict_missing_package

    def get_delete_package(self):
        dict_delete_package = []
        locrepodict    = {g.package_uuid : g for g in self.source_repo.packages() if g.package.lower().startswith(self.prefix) and not 'waptupgrade' in g.package.lower()}
        remoterepodict = {g.package_uuid : g for g in self.remote_repo.packages() if g.package.lower().startswith(self.prefix) and not 'waptupgrade' in g.package.lower()}

        for u in remoterepodict  :
            if not u in locrepodict :
                dict_delete_package.append(remoterepodict[u])
        return dict_delete_package

    def upload_packages(self,list_packages=[]):
        for pe in list_packages:
            full_url = pe.repo_url + '/' + pe.filename
            puuid = pe.package_uuid
            print(full_url)
            tmpfile = makepath(self.tmpdir,puuid)
            try:
                wget(full_url,tmpfile,requests_session=self.sessionwaptsource)
                self.sessionwaptremote.post('%s/api/v3/upload_packages' % self.wapt_url_remote, data=FileChunks(tmpfile, progress_hook=None).get(), auth=None, timeout=300)
            finally:
                remove_file(tmpfile)

    def delete_package(self,list_packages=[]):
        for pe in list_packages:
            print(pe.filename)
            r = self.sessionwaptremote.post('%s/api/v3/packages_delete' % self.wapt_url_remote,data=json.dumps([pe.filename]) , auth=None, timeout=300,headers = {'Content-Type': 'application/json; charset= utf-8'})
            print(r.content)

    def upload_missing_packages(self):
        self.upload_packages(self.get_missing_package())

    def delete_package_not_found_in_source(self):
        self.delete_package(self.get_delete_package())

    def sync_wads_config(self):
        missing_config=[]


        datasource = [u for u in json.loads(self.sessionwaptsource.get(self.wapt_url_source + '/api/v3/get_deploy_config').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]
        dataremote = [u for u in json.loads(self.sessionwaptremote.get(self.wapt_url_remote + '/api/v3/get_deploy_config').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]

        list_attr = ["signature",'signer','signature_date','signed_attributes','signer_certificate','name','os_type','xml_conf','iso_config_name','script_postinstall','install_wapt','signer_certificate',"ipxe_script","signer_fingerprint"]

        wads_config_list_source = []
        for entry in datasource:
            entry2 = {}
            for attr in list_attr :
                entry2[attr] = entry[attr]
            wads_config_list_source.append(entry2)

        wads_config_list_remote = []
        for entry in dataremote:
            entry2 = {}
            for attr in list_attr :
                entry2[attr] = entry[attr]
            wads_config_list_remote.append(entry2)

            #delete old conf
            if not entry2 in wads_config_list_source:
                self.sessionwaptremote.post(self.wapt_url_remote + '/api/v3/delete_deploy_config',data=json.dumps([entry['id']]),headers = {'Content-Type': 'application/json; charset= utf-8'})


        for entry in wads_config_list_source :
            if not entry in wads_config_list_remote:
                missing_config.append(entry)

        for conf in missing_config:
            self.sessionwaptremote.post(self.wapt_url_remote + '/api/v3/save_deploy_config',data=json.dumps([conf]),headers = {'Content-Type': 'application/json; charset= utf-8'})

    def sync_iso(self):
        missing_iso=[]
        datasource = [u for u in json.loads(self.sessionwaptsource.get(self.wapt_url_source + '/api/v3/get_iso_config').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]
        dataremote = [u for u in json.loads(self.sessionwaptremote.get(self.wapt_url_remote + '/api/v3/get_iso_config').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]
        list_attr = ['signer',
                        'signature_date',
                        'signed_attributes',
                        'signer_certificate',
                        'name',
                        'architecture',
                        'hash',
                        "signature",
                        "signer_fingerprint"]

        wads_iso_list_source = []
        for entry in datasource:
            entry2 = {}
            for attr in list_attr :
                entry2[attr] = entry[attr]
            wads_iso_list_source.append(entry2)

        wads_iso_list_remote = []
        for entry in dataremote:
            entry2 = {}
            for attr in list_attr :
                entry2[attr] = entry[attr]
            wads_iso_list_remote.append(entry2)

            #delete old conf
            if not entry2 in wads_iso_list_source:
                self.sessionwaptremote.post(self.wapt_url_remote + '/api/v3/delete_iso_config',data=json.dumps([entry['id']]),headers = {'Content-Type': 'application/json; charset= utf-8'})
                self.sessionwaptremote.post(self.wapt_url_remote + '/api/v3/delete_iso',data=json.dumps([entry['hash']]),headers = {'Content-Type': 'application/json; charset= utf-8'})


        for entry in wads_iso_list_source :
            if not entry in wads_iso_list_remote:
                missing_iso.append(entry)

        for conf in missing_iso:
            self.sessionwaptremote.post(self.wapt_url_remote + '/api/v3/save_iso_config',data=json.dumps([conf]),headers = {'Content-Type': 'application/json; charset= utf-8'})

        dataremote = json.loads(self.sessionwaptremote.get(self.wapt_url_remote + '/api/v3/get_iso_config').content).get('result',[])
        for entry in dataremote:
            if not entry.get('file_exists',False):
                if not entry['name'].lower().startswith(self.prefix):
                    continue
                hashiso = entry['hash']
                full_url = self.wapt_url_source + '/wads/iso/' + hashiso + '.iso'
                tmpfile = makepath(self.tmpdir,hashiso)
                try:
                    wget(full_url,tmpfile,requests_session=self.sessionwaptsource)
                    self.sessionwaptremote.post('%s/api/v3/upload_deploy_files?filename=%s.iso&folder=iso&overwrite=0&hash=%s&check_need_upload=0' % (self.wapt_url_remote,hashiso,hashiso), data=FileChunks(tmpfile, progress_hook=None).get(), auth=None, timeout=300)
                finally:
                    remove_file(tmpfile)

    def sync_drivers(self):


        missing_drivers=[]
        delete_drivers=[]
        datasource = [u for u in json.loads(self.sessionwaptsource.get(self.wapt_url_source + '/api/v3/get_driver_bundle_names').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]
        dataremote = [u for u in json.loads(self.sessionwaptremote.get(self.wapt_url_remote + '/api/v3/get_driver_bundle_names').content).get('result',[]) if u['name'].lower().startswith(self.prefix)]

        wads_drivers_list_source = []
        for entry in datasource:
            wads_drivers_list_source.append(entry)

        wads_drivers_list_remote = []
        for entry in dataremote:
            wads_drivers_list_remote.append(entry)

        for entry in wads_drivers_list_source :
            if not entry in wads_drivers_list_remote:
                missing_drivers.append(entry)

        for entry in wads_drivers_list_remote :
            if not entry in wads_drivers_list_source:
                delete_drivers.append(entry)

        for d in delete_drivers :
            r = json.loads(self.sessionwaptremote.post('%s/api/v3/delete_driver_bundles' % (self.wapt_url_remote), data=json.dumps([d['name']]) , auth=None, timeout=300,headers = {'Content-Type': 'application/json; charset= utf-8'}).content)['success']

        for d in missing_drivers:
            name_conf = d['name']
            for f in d['data']:
                r = json.loads(self.sessionwaptremote.post('%s/api/v3/upload_deploy_files?filename=%s&folder=drivers/files&overwrite=1&hash=%s&check_need_upload=1' % (self.wapt_url_remote,f,f), auth=None, timeout=300,headers = {'Content-Type': 'application/json; charset= utf-8'}).content)['success']
                if not r :
                    full_url = self.wapt_url_source + '/wads/drivers/files/' + f
                    tmpfile = makepath(self.tmpdir,f)
                    try:
                        wget(full_url,tmpfile,requests_session=self.sessionwaptsource)
                        self.sessionwaptremote.post('%s/api/v3/upload_deploy_files?filename=%s&folder=drivers/files&overwrite=0&hash=%s&check_need_upload=0' % (self.wapt_url_remote,f,f), data=FileChunks(tmpfile, progress_hook=None).get(), auth=None, timeout=300)
                    finally:
                        remove_file(tmpfile)

            try:
                namame_sha2 = sha256_for_data(name_conf)
                full_url = self.wapt_url_source + '/wads/drivers/conf/' + namame_sha2
                tmpfile = makepath(tempfile.gettempdir(),namame_sha2)
                wget(full_url,tmpfile,requests_session=self.sessionwaptsource)
                sha2file = sha256_for_file(tmpfile)
                self.sessionwaptremote.post('%s/api/v3/upload_deploy_files?filename=%s&folder=drivers/conf&overwrite=0&hash=%s&check_need_upload=0' % (self.wapt_url_remote,namame_sha2,sha2file), data=FileChunks(tmpfile, progress_hook=None).get(), auth=None, timeout=300)
            finally:
                remove_file(tmpfile)


def runync(datajson):

    #Init source server
    wsource = Wapt(config_filename=datajson['source']['inifile'])
    password_source = datajson['source']['password'] + '!'

    t = waptlicences.waptserver_login(datajson['source']['inifile'],datajson['source']['username'],password_source[:-1])
    if not 'session' in t['session_cookies']:
       session_cookies = [u for u in t['session_cookies'] if u['Domain'] == self.wsource.waptserver.server_url.split('://')[-1]][0]
    else:
       session_cookies = t['session_cookies']['session']
       session_cookies['Name'] = 'session'

    wapt_url_source = wsource.waptserver.server_url
    source_repo = WaptRemoteRepo(url=wsource.waptserver.server_url + '/wapt', verify_cert=wsource.waptserver.verify_cert)

    sessionwaptsource = get_requests_client_cert_session(wsource.waptserver.server_url,cert=(t['client_certificate'],t['client_private_key'],t['client_private_key_password']),verify=wsource.waptserver.verify_cert)

    sessionwaptsource.cookies.set(session_cookies['Name'], session_cookies['Value'], domain=session_cookies['Domain'])
    sessionwaptsource.verify = wsource.waptserver.verify_cert

    source_repo.client_certificate  = t['client_certificate']
    source_repo.client_private_key  = t["client_private_key"]
    source_client_private_key_password     = t["client_private_key_password"]

    def give_password_source(location=None,identity=None):
        return source_client_private_key_password

    source_repo.private_key_password_callback = give_password_source

    # Print Run sync
    for prefix in datajson["prefix"].split(','):
        for entry in datajson['remote']:
            print(entry["inifile"].split('/')[-1].split('.')[0])
            hh = RunSynchro( waptgetiniremote = entry["inifile"],
                            username_remote  = entry["username"],
                            password_remote  = entry["password"],
                            prefix = prefix,
                            tmpdir = datajson.get('tmpdir'),
                            sessionwaptsource = sessionwaptsource,
                            wsource = wsource,
                            source_repo = source_repo,
                            wapt_url_source = wapt_url_source)

            hh.delete_package_not_found_in_source()
            hh.upload_missing_packages()
            hh.sync_wads_config()
            hh.sync_drivers()
            hh.sync_iso()