# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
        
    api_url = "https://api.github.com/repos/hovancik/stretchly/releases/latest"
    latest_release = wgets(api_url, proxies=proxies, as_json=True)
    version = latest_release['tag_name'].replace('v', '')

    download_dict = {
	'windows-x64': f'Stretchly-Setup-{version}.exe',
        'macos-x64': f'Stretchly-{version}.dmg',
        'macos-arm': f'Stretchly-{version}-arm64.dmg',
    }
    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    for asset in latest_release["assets"]:
        if asset["name"] == download_dict[os_type]:
            download_url = asset["browser_download_url"]
            latest_bin = asset["name"]
            latest_bin_extension = latest_bin.rsplit(".", 1)[-1]
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated