# -*- coding: utf-8 -*-
from setuphelpers import *

install_path = makepath(programfiles, "Stretchly")


def install():
    bin_name = glob.glob("Stretchly-Setup-*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags=" /allusers /S",
        key="4f357cc2-fcfb-5fb1-89af-67446d29eff0",
        min_version=control.get_software_version(),
    )


def uninstall():
    for to_uninstall in installed_softwares("Stretchly"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])
        if isdir(install_path):
            remove_tree(install_path)
