from setuphelpers import *



def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    update_dict = {"windows": ".msi"}
    api_url = "https://api.github.com/repos/Stirling-Tools/Stirling-PDF/releases/latest"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "")
    for to_download in json_load["assets"]:
        if update_dict[control.target_os] in to_download["name"]:
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]
            break

    # Downloading latest binaries
    print(f"Latest version of {control.name} is: {version}")
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    
    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    # Deleting binaries
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
