# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    # Uninstalling older version of the software that can remains
    for to_uninstall in installed_softwares(name="Snagit"):
        if Version(to_uninstall["version"]) < Version(control.get_software_version()):
            print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])

    # Installing the software
    install_msi_if_needed(
        'snagit.msi',
        min_version=control.get_software_version(),
        properties={
            'START_NOW': 0,
            'TSC_START_AUTO': 0,
            'TSC_HIDE_REGISTRATION_KEY': 1
        }
    )

def uninstall():
    # Uninstalling the software
    for to_uninstall in installed_softwares(name="Snagit"):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])
    
    # Clean directories left
    users = glob.glob(makepath('C:', 'Users', '*'))

    print('Cleaning up folders')
    for user in users:
        if isdir(makepath('C:', 'Users', user, 'Documents', 'Snagit')):
            remove_tree(makepath('C:', 'Users', user, 'Documents', 'Snagit'))
        if isdir(makepath('C:', 'Users', user, 'TechSmith', 'Snagit')):
            remove_tree(makepath('C:', 'Users', user, 'TechSmith', 'Snagit'))