from setupdevhelpers import *
import requests

def update_package():
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    download_url = requests.head('https://slack.com/ssb/download-win64-msi',proxies=proxies).headers['location']
    print(f'Download URL is {download_url}')
    bin_name = download_url.split('/')[-1]
    print(f'Binary Name is {bin_name}')
    version = download_url.split('/')[-2]
    print(f'Latest Version is {version}')
    wget(download_url,bin_name,proxies=proxies)

    for f in glob.glob('*.msi'):
        if get_msi_properties(f)['ProductVersion'] != Version(version):
            remove(f)


    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated


