# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
import waptlicences

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    api_url = "https://api.github.com/repos/siyuan-note/siyuan/releases/latest"
        
    latest_release = wgets(api_url, proxies=proxies, as_json=True)
    version = latest_release['tag_name'].replace('v', '')

    download_dict = {
        'darwin-x64': f'siyuan-{version}-mac.dmg',
        'darwin-arm': f'siyuan-{version}-mac-arm64.dmg',
        'windows-x64': f'siyuan-{version}-win.exe',
    }
    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    for asset in latest_release["assets"]:
        if asset["name"] == download_dict[os_type]:
            download_url = asset["browser_download_url"]
            latest_bin = asset["name"]
            latest_bin_extension = latest_bin.rsplit(".", 1)[-1]
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    expected_issuer = "Yunnan Liandi Technology Co., Ltd."
    sign_name = waptlicences.check_exe_signing_certificate(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated