# -*- coding: utf-8 -*-
from setuphelpers import *

app_dir_name = "signal-desktop"
app_user_dir = makepath(user_local_appdata, "Programs", app_dir_name)
app_user_uninstall = makepath(app_user_dir, "Uninstall Signal.exe")
app_user_uninstall_cmd = f'"{app_user_uninstall}" /S'
app_user_updater = makepath(user_local_appdata, "signal-desktop-updater")
app_sys_dir = makepath(programfiles32, app_dir_name)
app_sys_path = makepath(app_sys_dir, "Signal.exe")


def install():
    # Specific app values
    package_version = control.get_software_version()
    bin_zip_string = f"signal-desktop-win-x64-{package_version}.zip"

    killalltasks(control.get_impacted_process_list())

    # Installing the package
    if isdir(app_sys_dir):
        remove_tree(app_sys_dir)

    unzip(bin_zip_string, makepath(programfiles32))
    create_programs_menu_shortcut("Signal", app_sys_path)


def uninstall():

    # Uninstalling the package
    if isdir(app_sys_dir):
        remove_tree(app_sys_dir)
    remove_programs_menu_shortcut("Signal")


def session_setup():
    print("Disabling: auto update check")
    if isdir(app_user_updater):
        remove_tree(app_user_updater)

    print("Uninstalling from user environnement if installed")
    if isfile(app_user_uninstall):
        print("Running " + app_user_uninstall_cmd)
        run(app_user_uninstall_cmd)
    remove_user_programs_menu_shortcut("Signal")
