# -*- coding: utf-8 -*-
from setuphelpers import *
import re


def read_file(filepath):
    with open(filepath, 'r', encoding='utf-8') as file:
        content = file.read()
    return content

def find_version(filename):
    version = re.search('version: .*', read_file(filename)).group(0)
    return version.split(':')[-1].strip()


def update_package():
    print("Download/Update package content from upstream binary sources")

    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    os_dict_yaml = { 'windows' : 'latest', 'darwin' : 'latest-mac' }
    yaml_download = f"https://updates.signal.org/desktop/{os_dict_yaml[control.target_os]}.yml"
    yaml_file = 'latest.yml'

    print(f"Downloading the yaml file: {yaml_download}")
    wget(yaml_download, yaml_file, proxies=proxies)

    # WAPT for the moment as no yaml parser
    # This part can be improved in the future
    version = find_version(yaml_file)

    latest_bin = f"signal-desktop-mac-universal-{version}.dmg"
    url_dl = f"https://updates.signal.org/desktop/{latest_bin}"

    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {url_dl}")

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: " + latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    for f in glob.glob('*.dmg'):
        if f != latest_bin:
            remove_file(f)
    
    remove_file(yaml_file)

    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated