# -*- coding: utf-8 -*-
from setuphelpers import *
from waptutils import create_recursive_zip
import waptlicences
import re

app_dir_name = "signal-desktop"
seven_zip_path = makepath(programfiles, "7-Zip", "7z.exe")

def read_file(filepath):
    with open(filepath, 'r', encoding='utf-8') as file:
        content = file.read()
    return content

def find_version(filename):
    version = re.search('version: .*', read_file(filename)).group(0)
    return version.split(':')[-1].strip()


def make_portable_install(latest_bin):

    archive_filename = latest_bin.replace('.exe', '.zip')
    print("Generate zip file with .exe file")

    if isdir(app_dir_name):
        remove_tree(app_dir_name)
    mkdirs(app_dir_name)

    try:
        # Unzip the exe file
        run(f'"{seven_zip_path}" e {latest_bin} -o{app_dir_name}')

        # Remove useless files extracted
        files_to_delete = ("nsExec.dll", "nsis7z.dll", "nsProcess.dll", "SpiderBanner.dll", "StdUtils.dll", "System.dll", "WinShell.dll")
        for file in files_to_delete:
            remove_file(makepath(app_dir_name, file))

        # Unzip the archive app-64.7z inside the extracted .exe
        app_7zip = makepath(app_dir_name, "app-64.7z")
        run(f'"{seven_zip_path}" x {app_7zip} -o{app_dir_name}\\')
        remove_file(app_7zip)

        # Make the zip file
        create_recursive_zip(archive_filename, app_dir_name, target_root=app_dir_name)

    except:
        error("Unabled to generate the zip file !")

    # Delete the folder
    remove_tree(app_dir_name)

    # Deleting outdated zip file
    for f in glob.glob("*.zip"):
        if f != archive_filename:
            remove_file(f)

    print("The zip file is correctly generated !")


def update_package():
    print("Download/Update package content from upstream binary sources")

    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    os_dict_yaml = { 'windows' : 'latest', 'darwin' : 'latest-mac' }
    yaml_download = f"https://updates.signal.org/desktop/{os_dict_yaml[control.target_os]}.yml"
    yaml_file = 'latest.yml'

    print(f"Downloading the yaml file: {yaml_download}")
    wget(yaml_download, yaml_file, proxies=proxies)

    # WAPT for the moment as no yaml parser
    # This part can be improved in the future
    version = find_version(yaml_file)

    latest_bin = f"signal-desktop-win-x64-{version}.exe"
    url_dl = f"https://updates.signal.org/desktop/{latest_bin}"

    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {url_dl}")

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: " + latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    for f in glob.glob('*.exe'):
        if Version(get_version_from_binary(f)) < Version(version):
            remove_file(f)

    expected_issuer = 'Signal Messenger, LLC'
    sign_name = waptlicences.check_exe_signing_certificate(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')

    make_portable_install(latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {version})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({version})")

    control.set_software_version(get_version_from_binary(latest_bin))
    control.save_control_to_wapt()

    # Deleting all binaries
    for f in glob.glob("*.exe"):
        remove_file(f)
    
    remove_file(yaml_file)

    # Validating update-package-sources
    return package_updated
