# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/mltframework/shotcut/releases/latest"
    bin_contains = ".AppImage"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "")
    for to_download in json_load["assets"]:
        if bin_contains in to_download["name"]:
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin)

    # Checking version from file
    if get_os_name() == "darwin" and "mac" in control.target_os.lower():
        version_from_file = get_version_from_binary(latest_bin)
        if Version(version_from_file, 4) == Version(version, 4):
            print(f"INFO: Binary file version ({version_from_file}) corresponds to online version ({version})")
        else:
            error(f"ERROR: Binary file version ({version_from_file}) do NOT corresponds to online version ({version})")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated
