# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import bs_find_all

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    url = "https://www.seafile.com/en/download/"

    # Getting latest version from official sources
    print(f"URL used is: {url}")
    bs_search = bs_find_all(url, "a", "class", "download-op")
    for i in bs_search:
        if "Seafile-x" in i["href"] and i["href"].endswith(".AppImage"):
            version = i.text
            download_url = i["href"]
            latest_bin = download_url.split("/")[-1]

    # Downloading latest binaries
    print(f"Latest {control.name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    for f in glob.glob("*.AppImage"):
        if f != latest_bin:
            remove_file(f)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated