# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2023
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *

def install():
    #Declare variables
    install_dir = makepath('/','opt',control.package.split('-',1)[1])
    appimage = glob.glob("*.AppImage")[0]
    
    #Make install dir
    if isdir(install_dir):
        remove_tree(install_dir)
    mkdirs(install_dir)

    #Copy appimage in install dir
    run('chmod a+x ./' + appimage)
    name_appimage = appimage.split('/')[-1]
    filecopyto(appimage, makepath(install_dir, name_appimage))

    #Extract image
    run(f'"./{appimage}" --appimage-extract')

def uninstall():
    install_dir = makepath('/','opt',control.package.split('-',1)[1])
    killalltasks("seafile")
    remove_tree(install_dir)