# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    base_url = "https://www.utc.fr/~mottelet/scilab_for_macOS.html"

    all_download_links = [
        (i['href'], i['href'].rsplit('/', 1)[-1].split('-')[1])
        for i in bs_find_all(base_url, 'a', 'href')
        if i.get_text(strip=True).endswith('arm64.dmg')
    ]

    download_url, version = max(all_download_links, key=lambda i: Version(i[1]))

    download_url = f"https://www.utc.fr/~mottelet/{download_url}"
    latest_bin = download_url.rsplit("/", 1)[-1]

    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies, cert="www-utc-fr.crt", user_agent="Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:130.0) Gecko/20100101 Firefox/130.0")
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    for f in glob.glob('*.dmg'):
        if f != latest_bin:
            remove_file(f)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {version})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({version})")

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
