# -*- coding: utf-8 -*-
from setuphelpers import *


def install():

    uninstall_older_version()
    install_dmg(glob.glob("scilab-*arm64.dmg")[0])


def uninstall():
    
    app_folder_name = f"scilab-{control.get_software_version()}.app"
    app_path = makepath("/Applications", app_folder_name)

    if isdir(app_path):
        remove_tree(app_path)


def uninstall_older_version():
    killalltasks(ensure_list(control.impacted_process))
    for soft in installed_softwares(control.name):
        if Version(soft['version']) < Version(control.get_software_version()):
            remove_tree(soft['install_location'])