# -*- coding: utf-8 -*-
from setuphelpers import *
import time
import glob
import json
import base64
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

locsrvrustdesk = makepath(programfiles,'RustDeskServer')

apiurl = ''

def install():

    #replace nssm by angelize
    if service_installed("RustDesk hbbs service"):
        service_delete('RustDesk hbbs service')

    if service_installed("RustDesk hbbr service"):
        service_delete('RustDesk hbbr service')

    bin_name = glob.glob("*.zip")[0]

    unzip(bin_name)

    if service_installed('RustDeskServer'):
        if service_is_running('RustDeskServer'):
            service_stop('RustDeskServer')

    copytree2("RustDeskServer",locsrvrustdesk)
    remove_file(makepath("rustdesk-server-windows-x86_64-unsigned",'x86_64','RustDeskServer.Setup.exe'))

    copytree2(makepath("rustdesk-server-windows-x86_64-unsigned",'x86_64'),locsrvrustdesk)
    mkdirs(makepath(locsrvrustdesk ,'log'))

    if not service_installed('RustDeskServer'):
        run(r'"%s" --install' % makepath(locsrvrustdesk,"RustDeskServer.exe"))

    run_notfatal('netsh advfirewall firewall delete rule name="%s" program="%s"'% ("hbbr", makepath(locsrvrustdesk, "hbbr.exe")))
    run_notfatal('netsh advfirewall firewall delete rule name="%s" program="%s"'% ("hbbs", makepath(locsrvrustdesk, "hbbs.exe")))


    run('netsh advfirewall firewall add rule name="%s" dir=in profile=private,domain,public action=allow program="%s" enable=yes'% ("hbbr", makepath(locsrvrustdesk, "hbbr.exe")))
    run('netsh advfirewall firewall add rule name="%s" dir=in profile=private,domain,public action=allow program="%s" enable=yes'% ("hbbs", makepath(locsrvrustdesk, "hbbs.exe")))

    if service_is_running('RustDeskServer'):
        service_stop('RustDeskServer')
    service_start('RustDeskServer')

def audit():

    hostname = get_hostname()
    nb=0
    while not glob.glob(makepath(locsrvrustdesk,'*.pub')):
        nb=nb+1
        if nb == 120:
            error("*.pub not found")
        time.sleep(1)

    pubkey = glob.glob(makepath(locsrvrustdesk,'*.pub'))[0]

    key = open(pubkey,'r').read()

    if not '.' in hostname:
        if not params.get("install_with_luti", False):
            error('please configure fqdn')

    print('fqdn use is %s' % hostname)

    config = {"host":hostname,"relay":hostname,"key":key,"api":apiurl}
    rustdesk_list = list(base64.b64encode(json.dumps(config,separators=(',', ':')).encode('utf-8')).decode('utf-8').replace('=',''))
    rustdesk_list.reverse()
    rustdesk_cfg = ''.join(rustdesk_list)

    data = {"config" : config, "rustdesk_cfg" : rustdesk_cfg}


    WAPT.write_audit_data_if_changed("rustdesk-server", 'rustdesk-server', data, max_count=365)
    return "OK"

def uninstall():
    service_delete('RustDeskServer')
    remove_tree(locsrvrustdesk)


