// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="what-is-rustc.html"><strong aria-hidden="true">1.</strong> What is rustc?</a></li><li class="chapter-item expanded "><a href="command-line-arguments.html"><strong aria-hidden="true">2.</strong> Command-line Arguments</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-line-arguments/print-options.html"><strong aria-hidden="true">2.1.</strong> Print Options</a></li><li class="chapter-item expanded "><a href="codegen-options/index.html"><strong aria-hidden="true">2.2.</strong> Codegen Options</a></li></ol></li><li class="chapter-item expanded "><a href="jobserver.html"><strong aria-hidden="true">3.</strong> Jobserver</a></li><li class="chapter-item expanded "><a href="lints/index.html"><strong aria-hidden="true">4.</strong> Lints</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="lints/levels.html"><strong aria-hidden="true">4.1.</strong> Lint Levels</a></li><li class="chapter-item expanded "><a href="lints/groups.html"><strong aria-hidden="true">4.2.</strong> Lint Groups</a></li><li class="chapter-item expanded "><a href="lints/listing/index.html"><strong aria-hidden="true">4.3.</strong> Lint Listing</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="lints/listing/allowed-by-default.html"><strong aria-hidden="true">4.3.1.</strong> Allowed-by-default Lints</a></li><li class="chapter-item expanded "><a href="lints/listing/warn-by-default.html"><strong aria-hidden="true">4.3.2.</strong> Warn-by-default Lints</a></li><li class="chapter-item expanded "><a href="lints/listing/deny-by-default.html"><strong aria-hidden="true">4.3.3.</strong> Deny-by-default Lints</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="json.html"><strong aria-hidden="true">5.</strong> JSON Output</a></li><li class="chapter-item expanded "><a href="tests/index.html"><strong aria-hidden="true">6.</strong> Tests</a></li><li class="chapter-item expanded "><a href="targets/index.html"><strong aria-hidden="true">7.</strong> Targets</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="targets/built-in.html"><strong aria-hidden="true">7.1.</strong> Built-in Targets</a></li><li class="chapter-item expanded "><a href="targets/custom.html"><strong aria-hidden="true">7.2.</strong> Custom Targets</a></li><li class="chapter-item expanded "><a href="targets/known-issues.html"><strong aria-hidden="true">7.3.</strong> Known Issues</a></li></ol></li><li class="chapter-item expanded "><a href="profile-guided-optimization.html"><strong aria-hidden="true">8.</strong> Profile-guided Optimization</a></li><li class="chapter-item expanded "><a href="instrument-coverage.html"><strong aria-hidden="true">9.</strong> Instrumentation-based Code Coverage</a></li><li class="chapter-item expanded "><a href="linker-plugin-lto.html"><strong aria-hidden="true">10.</strong> Linker-plugin-based LTO</a></li><li class="chapter-item expanded "><a href="check-cfg.html"><strong aria-hidden="true">11.</strong> Checking Conditional Configurations</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="check-cfg/cargo-specifics.html"><strong aria-hidden="true">11.1.</strong> Cargo Specifics</a></li></ol></li><li class="chapter-item expanded "><a href="remap-source-paths.html"><strong aria-hidden="true">12.</strong> Remap source paths</a></li><li class="chapter-item expanded "><a href="exploit-mitigations.html"><strong aria-hidden="true">13.</strong> Exploit Mitigations</a></li><li class="chapter-item expanded "><a href="symbol-mangling/index.html"><strong aria-hidden="true">14.</strong> Symbol Mangling</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="symbol-mangling/v0.html"><strong aria-hidden="true">14.1.</strong> v0 Symbol Format</a></li></ol></li><li class="chapter-item expanded "><a href="contributing.html"><strong aria-hidden="true">15.</strong> Contributing to rustc</a></li><li class="chapter-item expanded affix "><li class="spacer"></li><li class="chapter-item expanded "><a href="platform-support.html"><strong aria-hidden="true">16.</strong> Platform Support</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="target-tier-policy.html"><strong aria-hidden="true">16.1.</strong> Target Tier Policy</a></li><li class="chapter-item expanded "><a href="platform-support/TEMPLATE.html"><strong aria-hidden="true">16.2.</strong> Template for Target-specific Documentation</a></li><li class="chapter-item expanded "><a href="platform-support/arm64ec-pc-windows-msvc.html"><strong aria-hidden="true">16.3.</strong> arm64ec-pc-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/apple-darwin.html"><strong aria-hidden="true">16.4.</strong> *-apple-darwin</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/i686-apple-darwin.html"><strong aria-hidden="true">16.4.1.</strong> i686-apple-darwin</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64h-apple-darwin.html"><strong aria-hidden="true">16.4.2.</strong> x86_64h-apple-darwin</a></li><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-darwin.html"><strong aria-hidden="true">16.4.3.</strong> arm64e-apple-darwin</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-ios.html"><strong aria-hidden="true">16.5.</strong> *-apple-ios</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/apple-ios-macabi.html"><strong aria-hidden="true">16.5.1.</strong> *-apple-ios-macabi</a></li><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-ios.html"><strong aria-hidden="true">16.5.2.</strong> arm64e-apple-ios</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-tvos.html"><strong aria-hidden="true">16.6.</strong> *-apple-tvos</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-tvos.html"><strong aria-hidden="true">16.6.1.</strong> arm64e-apple-tvos</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-watchos.html"><strong aria-hidden="true">16.7.</strong> *-apple-watchos</a></li><li class="chapter-item expanded "><a href="platform-support/apple-visionos.html"><strong aria-hidden="true">16.8.</strong> *-apple-visionos</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-nintendo-switch-freestanding.html"><strong aria-hidden="true">16.9.</strong> aarch64-nintendo-switch-freestanding</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-linux-gnu.html"><strong aria-hidden="true">16.10.</strong> aarch64-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-linux-musl.html"><strong aria-hidden="true">16.11.</strong> aarch64-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-none.html"><strong aria-hidden="true">16.12.</strong> aarch64-unknown-none*</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64_be-unknown-none-softfloat.html"><strong aria-hidden="true">16.13.</strong> aarch64_be-unknown-none-softfloat</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64_be-unknown-linux-musl.html"><strong aria-hidden="true">16.14.</strong> aarch64_be-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/amdgcn-amd-amdhsa.html"><strong aria-hidden="true">16.15.</strong> amdgcn-amd-amdhsa</a></li><li class="chapter-item expanded "><a href="platform-support/arm-none-eabi.html"><strong aria-hidden="true">16.16.</strong> arm-none-eabi</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/armv4t-none-eabi.html"><strong aria-hidden="true">16.16.1.</strong> {arm,thumb}v4t-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv5te-none-eabi.html"><strong aria-hidden="true">16.16.2.</strong> {arm,thumb}v5te-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7a-none-eabi.html"><strong aria-hidden="true">16.16.3.</strong> armv7a-none-eabi{,hf}</a></li><li class="chapter-item expanded "><a href="platform-support/armv7r-none-eabi.html"><strong aria-hidden="true">16.16.4.</strong> armv7r-none-eabi{,hf}</a></li><li class="chapter-item expanded "><a href="platform-support/armebv7r-none-eabi.html"><strong aria-hidden="true">16.16.5.</strong> armebv7r-none-eabi{,hf}</a></li><li class="chapter-item expanded "><a href="platform-support/armv8r-none-eabihf.html"><strong aria-hidden="true">16.16.6.</strong> armv8r-none-eabihf</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv6m-none-eabi.html"><strong aria-hidden="true">16.16.7.</strong> thumbv6m-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv7em-none-eabi.html"><strong aria-hidden="true">16.16.8.</strong> thumbv7em-none-eabi*</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv7m-none-eabi.html"><strong aria-hidden="true">16.16.9.</strong> thumbv7m-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv8m.base-none-eabi.html"><strong aria-hidden="true">16.16.10.</strong> thumbv8m.base-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv8m.main-none-eabi.html"><strong aria-hidden="true">16.16.11.</strong> thumbv8m.main-none-eabi*</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/arm-linux.html"><strong aria-hidden="true">16.17.</strong> arm*-unknown-linux-*</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/armeb-unknown-linux-gnueabi.html"><strong aria-hidden="true">16.17.1.</strong> armeb-unknown-linux-gnueabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv5te-unknown-linux-gnueabi.html"><strong aria-hidden="true">16.17.2.</strong> armv5te-unknown-linux-gnueabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-unknown-linux-gnueabi.html"><strong aria-hidden="true">16.17.3.</strong> armv7-unknown-linux-gnueabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-unknown-linux-uclibceabi.html"><strong aria-hidden="true">16.17.4.</strong> armv7-unknown-linux-uclibceabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-unknown-linux-uclibceabihf.html"><strong aria-hidden="true">16.17.5.</strong> armv7-unknown-linux-uclibceabihf</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/armv6k-nintendo-3ds.html"><strong aria-hidden="true">16.18.</strong> armv6k-nintendo-3ds</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-rtems-eabihf.html"><strong aria-hidden="true">16.19.</strong> armv7-rtems-eabihf</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-sony-vita-newlibeabihf.html"><strong aria-hidden="true">16.20.</strong> armv7-sony-vita-newlibeabihf</a></li><li class="chapter-item expanded "><a href="platform-support/armv7a-vex-v5.html"><strong aria-hidden="true">16.21.</strong> armv7a-vex-v5</a></li><li class="chapter-item expanded "><a href="platform-support/android.html"><strong aria-hidden="true">16.22.</strong> *-android and *-androideabi</a></li><li class="chapter-item expanded "><a href="platform-support/openharmony.html"><strong aria-hidden="true">16.23.</strong> *-linux-ohos</a></li><li class="chapter-item expanded "><a href="platform-support/hurd.html"><strong aria-hidden="true">16.24.</strong> *-hurd-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-teeos.html"><strong aria-hidden="true">16.25.</strong> aarch64-unknown-teeos</a></li><li class="chapter-item expanded "><a href="platform-support/avr-none.html"><strong aria-hidden="true">16.26.</strong> avr-none</a></li><li class="chapter-item expanded "><a href="platform-support/esp-idf.html"><strong aria-hidden="true">16.27.</strong> *-espidf</a></li><li class="chapter-item expanded "><a href="platform-support/fuchsia.html"><strong aria-hidden="true">16.28.</strong> *-unknown-fuchsia</a></li><li class="chapter-item expanded "><a href="platform-support/trusty.html"><strong aria-hidden="true">16.29.</strong> *-unknown-trusty</a></li><li class="chapter-item expanded "><a href="platform-support/kmc-solid.html"><strong aria-hidden="true">16.30.</strong> *-kmc-solid_*</a></li><li class="chapter-item expanded "><a href="platform-support/csky-unknown-linux-gnuabiv2.html"><strong aria-hidden="true">16.31.</strong> csky-unknown-linux-gnuabiv2*</a></li><li class="chapter-item expanded "><a href="platform-support/hexagon-unknown-linux-musl.html"><strong aria-hidden="true">16.32.</strong> hexagon-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/hexagon-unknown-none-elf.html"><strong aria-hidden="true">16.33.</strong> hexagon-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/hexagon-unknown-qurt.html"><strong aria-hidden="true">16.34.</strong> hexagon-unknown-qurt</a></li><li class="chapter-item expanded "><a href="platform-support/illumos.html"><strong aria-hidden="true">16.35.</strong> illumos</a></li><li class="chapter-item expanded "><a href="platform-support/loongarch-linux.html"><strong aria-hidden="true">16.36.</strong> loongarch*-unknown-linux-*</a></li><li class="chapter-item expanded "><a href="platform-support/loongarch-none.html"><strong aria-hidden="true">16.37.</strong> loongarch*-unknown-none*</a></li><li class="chapter-item expanded "><a href="platform-support/lynxos178.html"><strong aria-hidden="true">16.38.</strong> *-lynxos178-*</a></li><li class="chapter-item expanded "><a href="platform-support/m68k-unknown-linux-gnu.html"><strong aria-hidden="true">16.39.</strong> m68k-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/m68k-unknown-none-elf.html"><strong aria-hidden="true">16.40.</strong> m68k-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/mips64-openwrt-linux-musl.html"><strong aria-hidden="true">16.41.</strong> mips64-openwrt-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/mips64-unknown-linux-muslabi64.html"><strong aria-hidden="true">16.42.</strong> mips64-unknown-linux-muslabi64</a></li><li class="chapter-item expanded "><a href="platform-support/mipsel-sony-psx.html"><strong aria-hidden="true">16.43.</strong> mipsel-sony-psx</a></li><li class="chapter-item expanded "><a href="platform-support/mipsel-unknown-linux-gnu.html"><strong aria-hidden="true">16.44.</strong> mipsel-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/mips-mti-none-elf.html"><strong aria-hidden="true">16.45.</strong> mips*-mti-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/mips-release-6.html"><strong aria-hidden="true">16.46.</strong> mipsisa*r6*-unknown-linux-gnu*</a></li><li class="chapter-item expanded "><a href="platform-support/nvptx64-nvidia-cuda.html"><strong aria-hidden="true">16.47.</strong> nvptx64-nvidia-cuda</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-openbsd.html"><strong aria-hidden="true">16.48.</strong> powerpc-unknown-openbsd</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-linux-gnuspe.html"><strong aria-hidden="true">16.49.</strong> powerpc-unknown-linux-gnuspe</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-linux-muslspe.html"><strong aria-hidden="true">16.50.</strong> powerpc-unknown-linux-muslspe</a></li><li class="chapter-item expanded "><a href="platform-support/aix.html"><strong aria-hidden="true">16.51.</strong> powerpc64-ibm-aix</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64-unknown-linux-musl.html"><strong aria-hidden="true">16.52.</strong> powerpc64-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64le-unknown-linux-gnu.html"><strong aria-hidden="true">16.53.</strong> powerpc64le-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64le-unknown-linux-musl.html"><strong aria-hidden="true">16.54.</strong> powerpc64le-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32e-unknown-none-elf.html"><strong aria-hidden="true">16.55.</strong> riscv32e*-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32-unknown-none-elf.html"><strong aria-hidden="true">16.56.</strong> riscv32i*-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32im-risc0-zkvm-elf.html"><strong aria-hidden="true">16.57.</strong> riscv32im-risc0-zkvm-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32imac-unknown-xous-elf.html"><strong aria-hidden="true">16.58.</strong> riscv32imac-unknown-xous-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv64gc-unknown-linux-gnu.html"><strong aria-hidden="true">16.59.</strong> riscv64gc-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/riscv64gc-unknown-linux-musl.html"><strong aria-hidden="true">16.60.</strong> riscv64gc-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/riscv64a23-unknown-linux-gnu.html"><strong aria-hidden="true">16.61.</strong> riscv64a23-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/s390x-unknown-linux-gnu.html"><strong aria-hidden="true">16.62.</strong> s390x-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/s390x-unknown-linux-musl.html"><strong aria-hidden="true">16.63.</strong> s390x-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/sparc-unknown-none-elf.html"><strong aria-hidden="true">16.64.</strong> sparc-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/solaris.html"><strong aria-hidden="true">16.65.</strong> solaris</a></li><li class="chapter-item expanded "><a href="platform-support/nto-qnx.html"><strong aria-hidden="true">16.66.</strong> *-nto-qnx-*</a></li><li class="chapter-item expanded "><a href="platform-support/unikraft-linux-musl.html"><strong aria-hidden="true">16.67.</strong> *-unikraft-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/helenos.html"><strong aria-hidden="true">16.68.</strong> *-unknown-helenos</a></li><li class="chapter-item expanded "><a href="platform-support/hermit.html"><strong aria-hidden="true">16.69.</strong> *-unknown-hermit</a></li><li class="chapter-item expanded "><a href="platform-support/freebsd.html"><strong aria-hidden="true">16.70.</strong> *-unknown-freebsd</a></li><li class="chapter-item expanded "><a href="platform-support/managarm.html"><strong aria-hidden="true">16.71.</strong> *-unknown-managarm-mlibc</a></li><li class="chapter-item expanded "><a href="platform-support/motor.html"><strong aria-hidden="true">16.72.</strong> *-unknown-motor</a></li><li class="chapter-item expanded "><a href="platform-support/netbsd.html"><strong aria-hidden="true">16.73.</strong> *-unknown-netbsd*</a></li><li class="chapter-item expanded "><a href="platform-support/openbsd.html"><strong aria-hidden="true">16.74.</strong> *-unknown-openbsd</a></li><li class="chapter-item expanded "><a href="platform-support/redox.html"><strong aria-hidden="true">16.75.</strong> *-unknown-redox</a></li><li class="chapter-item expanded "><a href="platform-support/unknown-uefi.html"><strong aria-hidden="true">16.76.</strong> *-unknown-uefi</a></li><li class="chapter-item expanded "><a href="platform-support/windows-msvc.html"><strong aria-hidden="true">16.77.</strong> *-unknown-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/uwp-windows-msvc.html"><strong aria-hidden="true">16.78.</strong> *-uwp-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/vxworks.html"><strong aria-hidden="true">16.79.</strong> *-wrs-vxworks</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip1.html"><strong aria-hidden="true">16.80.</strong> wasm32-wasip1</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip1-threads.html"><strong aria-hidden="true">16.81.</strong> wasm32-wasip1-threads</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip2.html"><strong aria-hidden="true">16.82.</strong> wasm32-wasip2</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip3.html"><strong aria-hidden="true">16.83.</strong> wasm32-wasip3</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wali-linux.html"><strong aria-hidden="true">16.84.</strong> wasm32-wali-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-unknown-emscripten.html"><strong aria-hidden="true">16.85.</strong> wasm32-unknown-emscripten</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-unknown-unknown.html"><strong aria-hidden="true">16.86.</strong> wasm32-unknown-unknown</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32v1-none.html"><strong aria-hidden="true">16.87.</strong> wasm32v1-none</a></li><li class="chapter-item expanded "><a href="platform-support/wasm64-unknown-unknown.html"><strong aria-hidden="true">16.88.</strong> wasm64-unknown-unknown</a></li><li class="chapter-item expanded "><a href="platform-support/windows-gnu.html"><strong aria-hidden="true">16.89.</strong> windows-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/windows-gnullvm.html"><strong aria-hidden="true">16.90.</strong> windows-gnullvm</a></li><li class="chapter-item expanded "><a href="platform-support/win7-windows-gnu.html"><strong aria-hidden="true">16.91.</strong> *-win7-windows-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/win7-windows-msvc.html"><strong aria-hidden="true">16.92.</strong> *-win7-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-fortanix-unknown-sgx.html"><strong aria-hidden="true">16.93.</strong> x86_64-fortanix-unknown-sgx</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-pc-cygwin.html"><strong aria-hidden="true">16.94.</strong> x86_64-pc-cygwin</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-unknown-linux-none.html"><strong aria-hidden="true">16.95.</strong> x86_64-unknown-linux-none</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-unknown-none.html"><strong aria-hidden="true">16.96.</strong> x86_64-unknown-none</a></li><li class="chapter-item expanded "><a href="platform-support/xtensa.html"><strong aria-hidden="true">16.97.</strong> xtensa-*-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/nuttx.html"><strong aria-hidden="true">16.98.</strong> *-nuttx-*</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
