# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()


    git_repo = "rust-lang/rust"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo

    # Getting latest informations from Github API
    json_load = json.loads(wgets(url_api, proxies=proxies))

    version = json_load["tag_name"]
    #version = "1.65.0"


    download_dict = {
        "windows-x64": f"https://static.rust-lang.org/dist/rust-{version}-x86_64-pc-windows-msvc.msi",
        "windows-x86": f"https://static.rust-lang.org/dist/rust-{version}-i686-pc-windows-msvc.msi",
        "windows-all": f"https://static.rust-lang.org/dist/rust-{version}-i686-pc-windows-msvc.msi",
        "linux-x64": f"https://static.rust-lang.org/dist/rust-{version}-x86_64-unknown-linux-gnu.tar.gz",
        "linux-arm64": f"https://static.rust-lang.org/dist/rust-{version}-aarch64-unknown-linux-gnu.tar.gz",
        "darwin-x64": f"https://static.rust-lang.org/dist/rust-{version}-x86_64-apple-darwin.tar.gz",
        "darwin-arm": f"https://static.rust-lang.org/dist/rust-{version}-aarch64-apple-darwin.tar.gz",
        "linux-arm": f"https://static.rust-lang.org/dist/rust-{version}-armv7-unknown-linux-gnueabihf.tar.gz"
    }
    download_url = download_dict[control.target_os + "-" + ensure_list(control.architecture)[0]]
    latest_bin = download_url.split("/")[-1]

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin, ["exe", "msi", "deb", "rpm", "dmg", "pkg", ".tar.gz", ".tar"])

    # Validating or not update-package-sources
    return package_updated
