# -*- coding: utf-8 -*-
from setuphelpers import *
import json

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_name = "rufus.exe"


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    git_repo = "pbatard/rufus"
    api_url = "https://api.github.com/repos/%s/releases/latest" % git_repo
    bin_end = bin_name.split(".")[-1]
    avoid_bin_end = "p.exe"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for download in json_load["assets"]:
        if download["name"].endswith(bin_end) and download["name"] != avoid_bin_end:
            download_url = download["browser_download_url"]
            break

    version = json_load["tag_name"].replace("v", "")
    latest_bin = bin_name

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % download_url)

    # Downloading latest binaries
    if isfile(bin_name):
        remove_file(bin_name)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

        # Checking version from file
        version_from_file = get_version_from_binary(latest_bin)
        if not version_from_file.startswith(version) and version_from_file != "":
            print("Changing version to the version number of the binary")
            version = version_from_file
        else:
            print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return result
