# -*- coding: utf-8 -*-
from setuphelpers import *

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_name = "rufus.exe"
app_name = "Rufus"
app_dir = makepath(programfiles32, app_name)
app_path = makepath(app_dir, bin_name)


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    app_path = makepath(app_dir, bin_name)

    # Getting installed software version
    if isfile(app_path):
        installed_version = get_version_from_binary(app_path)
    else:
        installed_version = None

    # Installing software
    print("Installing: %s" % app_name)
    if installed_version is None or Version(installed_version) < Version(package_version) or force:
        killalltasks(control.get_impacted_process_list())
        mkdirs(app_dir)
        if isfile(app_path):
            remove_file(app_path)
        print("Copying: %s to: %s" % (bin_name, app_dir))
        filecopyto(bin_name, app_dir)

        # Creating shortcuts
        create_desktop_shortcut(app_name, app_path)
        create_programs_menu_shortcut(app_name, app_path)

        # Adding software to "list-registry"
        print("Registering %s to Windows Registry" % app_name)
        register_windows_uninstall(control, win64app=False)
        register_uninstall(app_name, icon=app_path)
    else:
        print("%s already installed. Skipping" % app_name)


def uninstall():
    # Uninstalling software
    killalltasks(control.get_impacted_process_list())
    if isdir(app_dir):
        remove_tree(app_dir)
    unregister_uninstall(app_name)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)


def session_setup():
    print("Disabling: update-check on start-up")
    registry_set(HKEY_CURRENT_USER, r"SOFTWARE\Akeo Consulting\Rufus", "UpdateCheckInterval", 0xFFFFFFFF, type=REG_DWORD)


def audit():
    # Declaring local variables
    package_version = control.get_software_version()

    # Getting installed software version
    if isfile(app_path):
        installed_version = get_version_from_binary(app_path)
    else:
        installed_version = None

    # Auditing software
    print("Auditing: %s" % control.package)
    if installed_version is None or installed_version < package_version:
        print("%s version is incorrect (%s)" % (app_name, installed_version))
        return "ERROR"
    else:
        print("%s is installed in correct version (%s)" % (app_name, installed_version))
        return "OK"
