# -*- coding: utf-8 -*-
from setuphelpers import *
import json

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
silentflags = "/S /allusers /disableAutoUpdates"
app_uninstallkey = "9b73a9fb-f1d5-59ee-b41e-e1dd393a748a"


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*.exe")[0]

    # Installing the software
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags=silentflags,
        key=app_uninstallkey,
        min_version=package_version,
    )

    if params.get("remove_desktop_shortcut"):
        remove_desktop_shortcut(control.name)


def session_setup():
    # Declaring local variables
    user_config_json = "config.json"
    user_config_dir = makepath(user_appdata, "Rocket.Chat")
    user_config_json_path = makepath(user_config_dir, user_config_json)
    user_config_json_content = json.loads(
        '{"doCheckForUpdatesOnStartup": false,"isEachUpdatesSettingConfigurable": false,"isUpdatingEnabled": false,"isTrayIconEnabled": true}'
    )

    # Writting configuration file
    print("Disabling: auto-update-check")
    if not isdir(user_config_dir):
        mkdirs(user_config_dir)
    if isfile(user_config_json_path):
        data = json_load_file(user_config_json_path)
        data.update(user_config_json_content)
    else:
        data = user_config_json_content
    json_write_file(user_config_json_path, data)
