# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    api_url = "https://api.github.com/repos/RocketChat/Rocket.Chat.Electron/releases/latest"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for download in json_load["assets"]:
        if download["name"].endswith("arm64.exe"):
            download_url = download["browser_download_url"]
            version = json_load["tag_name"]
            latest_bin = download["name"]
            break

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

        for f in glob.glob("*.exe"):
            if f != latest_bin:
                remove_file(f)

        # Checking version from file
        version_from_file = get_version_from_binary(latest_bin)
        # if not version_from_file.startswith(version) and version_from_file != '':
        if Version(version_from_file) != Version(version) and version_from_file != "":
            print("Changing version to the version number of the binary")
            version = version_from_file
        else:
            print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return result
