# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    print("Update package content from upstream binary sources")
    from waptpackage import PackageEntry
    import json

    app_name = control.name
    url = control.sources

    # Get Proxy informations from WAPT settings
    proxies = {}
    if isfile(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini")):
        proxywapt = inifile_readstring(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini"), "global", "http_proxy")
        if proxywapt:
            proxies = {"http": proxywapt, "https": proxywapt}

    binaryfile, url_dl = [
        (str(p["name"]), str(p["browser_download_url"]))
        for p in json.loads(wgets("https://api.github.com/repos/RocketChat/Rocket.Chat.Electron/releases/latest", proxies=proxies))["assets"]
        if ".dmg" in p["name"]
    ][0]
    version = url_dl.split("/")[-2]

    print("Latest " + app_name + " version is: " + version)
    print("Download url is: " + url_dl)

    # Deleting outdated binaries
    for actual_bin in glob.glob("*.dmg"):
        if actual_bin != binaryfile:
            print(actual_bin + " Deleted")
            remove_file(actual_bin)

    # Downloading latest binaires
    if not isfile(binaryfile):
        print("Downloading " + url_dl)
        wget(url_dl, binaryfile, proxies=proxies)

        # Changing version of the package
        control.version = "%s-%s" % (version, int(control.version.split("-")[-1]) + 1)
        control.save_control_to_wapt()
        print("Changing package version to: %s in WAPT\\control" % control.version)
