function module(e,t,a){(function(t){let r=e("./backend"),n=e("./cryptography-key"),s=e("./keytypes/ed25519sk"),i=e("./keytypes/ed25519pk"),o=e("./backend/libsodium-wrappers"),c=e("./sodium-error"),y=e("./backend/sodiumnative"),u=e("./keytypes/x25519pk"),h=e("./keytypes/x25519sk"),_=e("./util");"undefined"==typeof Buffer&&e("buffer/").Buffer;class d{constructor(e){if(!(e instanceof r))throw TypeError("Backend object must implement the backend function");this.backend=e,_.populateConstants(this)}getBackendName(){return this.backend.backendName}isSodiumNative(){return this.backend instanceof y}isLibsodiumWrappers(){return this.backend instanceof o}static async auto(){let e;try{e=await y.init()}catch(t){e=await o.init()}return e||(e=await o.init()),_.populateConstants(e),new d(e)}async ensureLoaded(){if(void 0===this.backend)try{await d.auto()}catch(e){this.backend=await o.init()}}async crypto_aead_xchacha20poly1305_ietf_decrypt(e,t,a){let r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"";if(await this.ensureLoaded(),24!==t.length)throw new c("Argument 2 must be 24 bytes");if(!(a instanceof n))throw TypeError("Argument 3 must be an instance of CryptographyKey");return await this.backend.crypto_aead_xchacha20poly1305_ietf_decrypt(await _.toBuffer(e),r.length>0?await _.toBuffer(r):null,await _.toBuffer(t),a)}async crypto_aead_xchacha20poly1305_ietf_encrypt(e,t,a){let r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"";if(await this.ensureLoaded(),24!==t.length)throw new c("Argument 2 must be 24 bytes");if(!(a instanceof n))throw TypeError("Argument 3 must be an instance of CryptographyKey");return await this.backend.crypto_aead_xchacha20poly1305_ietf_encrypt(await _.toBuffer(e),r.length>0?await _.toBuffer(r):null,await _.toBuffer(t),a)}async crypto_aead_xchacha20poly1305_ietf_keygen(){return new n(await this.backend.randombytes_buf(32))}async crypto_auth(e,t){if(await this.ensureLoaded(),!(t instanceof n))throw TypeError("Argument 2 must be an instance of CryptographyKey");return await this.ensureLoaded(),await this.backend.crypto_auth(await _.toBuffer(e),t)}async crypto_auth_keygen(){return new n(await this.backend.randombytes_buf(32))}async crypto_auth_verify(e,t,a){if(await this.ensureLoaded(),!(t instanceof n))throw TypeError("Argument 2 must be an instance of CryptographyKey");return await this.ensureLoaded(),await this.backend.crypto_auth_verify(await _.toBuffer(a),await _.toBuffer(e),t)}async crypto_box(e,t,a,r){if(await this.ensureLoaded(),!(a instanceof h))throw TypeError("Argument 3 must be an instance of X25519SecretKey");if(!(r instanceof u))throw TypeError("Argument 4 must be an instance of X25519PublicKey");if(24!==(t=await _.toBuffer(t)).length)throw new c("Nonce must be a buffer of exactly 24 bytes");return this.backend.crypto_box(await _.toBuffer(e),await _.toBuffer(t),a,r)}async crypto_box_open(e,t,a,r){if(await this.ensureLoaded(),!(a instanceof h))throw TypeError("Argument 3 must be an instance of X25519SecretKey");if(!(r instanceof u))throw TypeError("Argument 4 must be an instance of X25519PublicKey");if((e=await _.toBuffer(e)).length<16)throw new c("Ciphertext must be a buffer of at least 16 bytes");if(24!==(t=await _.toBuffer(t)).length)throw new c("Nonce must be a buffer of exactly 24 bytes");return this.backend.crypto_box_open(e,t,a,r)}async crypto_box_keypair(){return await this.ensureLoaded(),this.backend.crypto_box_keypair()}async crypto_box_keypair_from_secretkey_and_publickey(e,t){if(await this.ensureLoaded(),!(e instanceof h))throw TypeError("Argument 1 must be an instance of X25519SecretKey");if(!(t instanceof u))throw TypeError("Argument 2 must be an instance of X25519PublicKey");return await this.backend.crypto_box_keypair_from_secretkey_and_publickey(e,t)}async crypto_box_secretkey(e){if(64!==e.getLength())throw new c("Keypair must be 64 bytes");return new h(Buffer.from(e.getBuffer().slice(0,32)))}async crypto_box_publickey(e){if(64!==e.getLength())throw new c("Keypair must be 64 bytes");return new u(Buffer.from(e.getBuffer().slice(32,64)))}async crypto_box_publickey_from_secretkey(e){if(await this.ensureLoaded(),!(e instanceof h))throw TypeError("Argument 1 must be an instance of X25519SecretKey");return new u(await this.backend.crypto_scalarmult_base(e))}async crypto_box_seal(e,t){if(await this.ensureLoaded(),!(t instanceof u))throw TypeError("Argument 2 must be an instance of X25519PublicKey");return await this.backend.crypto_box_seal(e,t)}async crypto_box_seal_open(e,t,a){if(await this.ensureLoaded(),!(t instanceof u))throw TypeError("Argument 2 must be an instance of X25519PublicKey");if(!(a instanceof h))throw TypeError("Argument 3 must be an instance of X25519SecretKey");return await this.backend.crypto_box_seal_open(await _.toBuffer(e),t,a)}async crypto_generichash(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:32;return await this.ensureLoaded(),await this.backend.crypto_generichash(e,t,a)}async crypto_generichash_init(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:32;return await this.ensureLoaded(),await this.backend.crypto_generichash_init(e,t)}async crypto_generichash_update(e,t){return await this.ensureLoaded(),await this.backend.crypto_generichash_update(e,t)}async crypto_generichash_final(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:32;return await this.ensureLoaded(),await this.backend.crypto_generichash_final(e,t)}async crypto_generichash_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_GENERICHASH_KEYBYTES))}async crypto_kdf_derive_from_key(e,t,a,r){if(await this.ensureLoaded(),e<1)throw new c("Length must be a positive integer.");if(t<0)throw new c("Key ID must be an unsigned integer");return await this.backend.crypto_kdf_derive_from_key(e,t,a,r)}async crypto_kdf_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_KDF_KEYBYTES))}async crypto_kx_keypair(){return this.crypto_box_keypair()}async crypto_kx_seed_keypair(e){await this.ensureLoaded();let t=await this.backend.crypto_generichash(e,null,this.CRYPTO_KX_SECRETKEYBYTES),a=await this.backend.crypto_scalarmult_base(new n(t));return new n(Buffer.concat([t,a]))}async crypto_kx_client_session_keys(e,t,a){if(await this.ensureLoaded(),!(e instanceof u))throw TypeError("Argument 1 must be an instance of X25519PublicKey");if(!(t instanceof h))throw TypeError("Argument 2 must be an instance of X25519SecretKey");if(!(a instanceof u))throw TypeError("Argument 3 must be an instance of X25519PublicKey");return this.backend.crypto_kx_client_session_keys(e,t,a)}async crypto_kx_server_session_keys(e,t,a){if(await this.ensureLoaded(),!(e instanceof u))throw TypeError("Argument 1 must be an instance of X25519PublicKey");if(!(t instanceof h))throw TypeError("Argument 2 must be an instance of X25519SecretKey");if(!(a instanceof u))throw TypeError("Argument 3 must be an instance of X25519PublicKey");return this.backend.crypto_kx_server_session_keys(e,t,a)}async crypto_onetimeauth(e,t){if(!(t instanceof n))throw TypeError("Argument 2 must be an instance of CryptographyKey");return await this.backend.crypto_onetimeauth(await _.toBuffer(e),t)}async crypto_onetimeauth_verify(e,t,a){if(!(t instanceof n))throw TypeError("Argument 2 must be an instance of CryptographyKey");return await this.backend.crypto_onetimeauth_verify(await _.toBuffer(e),t,await _.toBuffer(a))}async crypto_onetimeauth_keygen(){return new n(await this.backend.randombytes_buf(32))}async crypto_pwhash(e,t,a,r,s){let i=arguments.length>5&&void 0!==arguments[5]?arguments[5]:null;return await this.ensureLoaded(),i||(i=this.CRYPTO_PWHASH_ALG_DEFAULT),new n(await this.backend.crypto_pwhash(e,await _.toBuffer(t),await _.toBuffer(a),r,s,i))}async crypto_pwhash_str(e,t,a){return await this.ensureLoaded(),await this.backend.crypto_pwhash_str(e,t,a)}async crypto_pwhash_str_verify(e,t){return await this.ensureLoaded(),await this.backend.crypto_pwhash_str_verify(e,t)}async crypto_pwhash_str_needs_rehash(e,t,a){return await this.ensureLoaded(),await this.backend.crypto_pwhash_str_needs_rehash(e,t,a)}async crypto_scalarmult(e,t){if(await this.ensureLoaded(),!(e instanceof h))throw TypeError("Argument 1 must be an instance of X25519SecretKey");if(!(t instanceof u))throw TypeError("Argument 2 must be an instance of X25519PublicKey");return await this.backend.crypto_scalarmult(e,t)}async crypto_scalarmult_base(e){if(await this.ensureLoaded(),!(e instanceof h))throw TypeError("Argument 1 must be an instance of X25519SecretKey");return new u(await this.backend.crypto_scalarmult_base(e))}async crypto_secretbox(e,t,a){if(await this.ensureLoaded(),a.isEd25519Key()||a.isX25519Key())throw TypeError("Argument 3 must not be an asymmetric key");if(24!==(t=await _.toBuffer(t)).length)throw new c("Nonce must be a buffer of exactly 24 bytes");return await this.backend.crypto_secretbox(e,t,a)}async crypto_secretbox_open(e,t,a){if(await this.ensureLoaded(),a.isEd25519Key()||a.isX25519Key())throw TypeError("Argument 3 must not be an asymmetric key");if((e=await _.toBuffer(e)).length<16)throw new c("Ciphertext must be a buffer of at least 16 bytes");if(24!==(t=await _.toBuffer(t)).length)throw new c("Nonce must be a buffer of exactly 24 bytes");return await this.backend.crypto_secretbox_open(e,t,a)}async crypto_secretbox_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_SECRETBOX_KEYBYTES))}async crypto_secretstream_xchacha20poly1305_init_push(e){if(await this.ensureLoaded(),!(e instanceof n))throw TypeError("Key must be an instance of CryptographyKey");if(32!==e.getLength())throw new c("crypto_secretstream keys must be 32 bytes long");let[t,a]=await this.backend.crypto_secretstream_xchacha20poly1305_init_push(e);return Object.freeze({header:a,push:this.crypto_secretstream_xchacha20poly1305_push.bind(this,t),rekey:this.crypto_secretstream_xchacha20poly1305_rekey.bind(this,t)})}async crypto_secretstream_xchacha20poly1305_init_pull(e,t){if(await this.ensureLoaded(),24!==(t=await _.toBuffer(t)).length)throw new c("crypto_secretstream headers must be 24 bytes long");if(!(e instanceof n))throw TypeError("Key must be an instance of CryptographyKey");if(32!==e.getLength())throw new c("crypto_secretstream keys must be 32 bytes long");let a=await this.backend.crypto_secretstream_xchacha20poly1305_init_pull(t,e);return Object.freeze({pull:this.crypto_secretstream_xchacha20poly1305_pull.bind(this,a)})}async crypto_secretstream_xchacha20poly1305_push(e,t){let a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return await this.ensureLoaded(),this.backend.crypto_secretstream_xchacha20poly1305_push(e,t,a,r)}async crypto_secretstream_xchacha20poly1305_pull(e,t){let a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;return await this.ensureLoaded(),this.backend.crypto_secretstream_xchacha20poly1305_pull(e,t,a,r)}async crypto_secretstream_xchacha20poly1305_rekey(e){await this.ensureLoaded(),await this.backend.crypto_secretstream_xchacha20poly1305_rekey(e)}async crypto_secretstream_xchacha20poly1305_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_KEYBYTES))}async crypto_shorthash(e,t){return await this.ensureLoaded(),await this.backend.crypto_shorthash(await _.toBuffer(e),t)}async crypto_shorthash_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_SHORTHASH_KEYBYTES))}async crypto_sign(e,t){if(await this.ensureLoaded(),!(t instanceof s))throw TypeError("Argument 2 must be an instance of Ed25519SecretKey");return this.backend.crypto_sign(e,t)}async crypto_sign_open(e,t){if(await this.ensureLoaded(),!(t instanceof i))throw TypeError("Argument 2 must be an instance of Ed25519PublicKey");return this.backend.crypto_sign_open(e,t)}async crypto_sign_detached(e,t){if(await this.ensureLoaded(),!(t instanceof s))throw TypeError("Argument 2 must be an instance of Ed25519SecretKey");return this.backend.crypto_sign_detached(e,t)}async crypto_sign_verify_detached(e,t,a){if(await this.ensureLoaded(),!(t instanceof i))throw TypeError("Argument 2 must be an instance of Ed25519PublicKey");return this.backend.crypto_sign_verify_detached(e,t,a)}async crypto_sign_secretkey(e){if(96!==e.getLength())throw new c("Keypair must be 96 bytes");return new s(await _.toBuffer(e.getBuffer().slice(0,64)))}async crypto_sign_publickey(e){if(96!==e.getLength())throw new c("Keypair must be 96 bytes");return new i(e.getBuffer().slice(64,96))}async crypto_sign_keypair(){return await this.ensureLoaded(),this.backend.crypto_sign_keypair()}async crypto_sign_seed_keypair(e){if(await this.ensureLoaded(),e instanceof n&&(e=e.getBuffer()),32!==(e=await _.toBuffer(e)).length)throw new c("Seed must be 32 bytes long; got ".concat(e.length));return this.backend.crypto_sign_seed_keypair(e)}async crypto_sign_ed25519_sk_to_curve25519(e){return await this.ensureLoaded(),new h(await this.backend.crypto_sign_ed25519_sk_to_curve25519(e))}async crypto_sign_ed25519_pk_to_curve25519(e){return await this.ensureLoaded(),new u(await this.backend.crypto_sign_ed25519_pk_to_curve25519(e))}async crypto_stream(e,t,a){return await this.ensureLoaded(),this.backend.crypto_stream(e,t,a)}async crypto_stream_xor(e,t,a){return await this.ensureLoaded(),this.backend.crypto_stream_xor(e,t,a)}async crypto_stream_keygen(){return new n(await this.backend.randombytes_buf(this.CRYPTO_STREAM_KEYBYTES))}async randombytes_buf(e){return await this.ensureLoaded(),await this.backend.randombytes_buf(e)}async randombytes_uniform(e){return await this.ensureLoaded(),this.backend.randombytes_uniform(e)}async sodium_add(e,t){return await this.ensureLoaded(),await this.backend.sodium_add(await _.toBuffer(e),await _.toBuffer(t))}async sodium_bin2hex(e){return await this.ensureLoaded(),this.backend.sodium_bin2hex(e)}async sodium_compare(e,t){return await this.ensureLoaded(),this.backend.sodium_compare(e,t)}async sodium_hex2bin(e){return await this.ensureLoaded(),this.backend.sodium_hex2bin(e)}async sodium_increment(e){return await this.ensureLoaded(),this.backend.sodium_increment(e)}async sodium_is_zero(e,t){return await this.ensureLoaded(),this.backend.sodium_is_zero(e,t)}async sodium_memcmp(e,t){return await this.ensureLoaded(),this.backend.sodium_memcmp(e,t)}async sodium_memzero(e){await this.ensureLoaded(),await this.backend.sodium_memzero(e)}async sodium_pad(e,t){return await this.ensureLoaded(),this.backend.sodium_pad(e,t)}async sodium_unpad(e,t){return await this.ensureLoaded(),this.backend.sodium_unpad(e,t)}}a.exports=d}).call(this,a)}
//# sourceMappingURL=/dynamic/node_modules/sodium-plus/lib/92dbe292958ac2b4768b4170c8bf85d9ec4df9fe.map
