function module(e,t,n){let i,o,r,s;n.export({Transport:()=>c}),n.link("../../../api/emitter.js",{EmitterImpl(e){i=e}},0),n.link("../../../api/exceptions/state-transition.js",{StateTransitionError(e){o=e}},1),n.link("../../../api/transport-state.js",{TransportState(e){r=e}},2),n.link("../../../grammar/grammar.js",{Grammar(e){s=e}},3);class c{constructor(e,t){if(this._state=r.Disconnected,this.transitioningState=!1,this._stateEventEmitter=new i,this.logger=e,t){let e=null==t?void 0:t.wsServers,n=null==t?void 0:t.maxReconnectionAttempts;void 0!==e&&this.logger.warn('The transport option "wsServers" as has apparently been specified and has been deprecated. It will no longer be available starting with SIP.js release 0.16.0. Please update accordingly.'),void 0!==n&&this.logger.warn('The transport option "maxReconnectionAttempts" as has apparently been specified and has been deprecated. It will no longer be available starting with SIP.js release 0.16.0. Please update accordingly.'),e&&!t.server&&("string"==typeof e&&(t.server=e),e instanceof Array&&(t.server=e[0]))}this.configuration=Object.assign(Object.assign({},c.defaultOptions),t);let n=this.configuration.server,o=s.parse(n,"absoluteURI");if(-1===o)throw this.logger.error(`Invalid WebSocket Server URL "${n}"`),Error("Invalid WebSocket Server URL");if(!["wss","ws","udp"].includes(o.scheme))throw this.logger.error(`Invalid scheme in WebSocket Server URL "${n}"`),Error("Invalid scheme in WebSocket Server URL");this._protocol=o.scheme.toUpperCase()}dispose(){return this.disconnect()}get protocol(){return this._protocol}get server(){return this.configuration.server}get state(){return this._state}get stateChange(){return this._stateEventEmitter}get ws(){return this._ws}connect(){return this._connect()}disconnect(){return this._disconnect()}isConnected(){return this.state===r.Connected}send(e){return this._send(e)}_connect(){let e;switch(this.logger.log(`Connecting ${this.server}`),this.state){case r.Connecting:if(this.transitioningState)return Promise.reject(this.transitionLoopDetectedError(r.Connecting));if(!this.connectPromise)throw Error("Connect promise must be defined.");return this.connectPromise;case r.Connected:if(this.transitioningState)return Promise.reject(this.transitionLoopDetectedError(r.Connecting));if(this.connectPromise)throw Error("Connect promise must not be defined.");return Promise.resolve();case r.Disconnecting:if(this.connectPromise)throw Error("Connect promise must not be defined.");try{this.transitionState(r.Connecting)}catch(e){if(e instanceof o)return Promise.reject(e);throw e}break;case r.Disconnected:if(this.connectPromise)throw Error("Connect promise must not be defined.");try{this.transitionState(r.Connecting)}catch(e){if(e instanceof o)return Promise.reject(e);throw e}break;default:throw Error("Unknown state")}try{(e=new WebSocket(this.server,"sip")).binaryType="arraybuffer",e.addEventListener("close",t=>this.onWebSocketClose(t,e)),e.addEventListener("error",t=>this.onWebSocketError(t,e)),e.addEventListener("open",t=>this.onWebSocketOpen(t,e)),e.addEventListener("message",t=>this.onWebSocketMessage(t,e)),this._ws=e}catch(e){return this._ws=void 0,this.logger.error("WebSocket construction failed."),this.logger.error(e.toString()),new Promise((t,n)=>{this.connectResolve=t,this.connectReject=n,this.transitionState(r.Disconnected,e)})}return this.connectPromise=new Promise((t,n)=>{this.connectResolve=t,this.connectReject=n,this.connectTimeout=setTimeout(()=>{this.logger.warn("Connect timed out. Exceeded time set in configuration.connectionTimeout: "+this.configuration.connectionTimeout+"s."),e.close(1e3)},1e3*this.configuration.connectionTimeout)}),this.connectPromise}_disconnect(){switch(this.logger.log(`Disconnecting ${this.server}`),this.state){case r.Connecting:if(this.disconnectPromise)throw Error("Disconnect promise must not be defined.");try{this.transitionState(r.Disconnecting)}catch(e){if(e instanceof o)return Promise.reject(e);throw e}break;case r.Connected:if(this.disconnectPromise)throw Error("Disconnect promise must not be defined.");try{this.transitionState(r.Disconnecting)}catch(e){if(e instanceof o)return Promise.reject(e);throw e}break;case r.Disconnecting:if(this.transitioningState)return Promise.reject(this.transitionLoopDetectedError(r.Disconnecting));if(!this.disconnectPromise)throw Error("Disconnect promise must be defined.");return this.disconnectPromise;case r.Disconnected:if(this.transitioningState)return Promise.reject(this.transitionLoopDetectedError(r.Disconnecting));if(this.disconnectPromise)throw Error("Disconnect promise must not be defined.");return Promise.resolve();default:throw Error("Unknown state")}if(!this._ws)throw Error("WebSocket must be defined.");let e=this._ws;return this.disconnectPromise=new Promise((t,n)=>{this.disconnectResolve=t,this.disconnectReject=n;try{e.close(1e3)}catch(e){throw this.logger.error("WebSocket close failed."),this.logger.error(e.toString()),e}}),this.disconnectPromise}_send(e){if(!0===this.configuration.traceSip&&this.logger.log("Sending WebSocket message:\n\n"+e+"\n"),this._state!==r.Connected)return Promise.reject(Error("Not connected."));if(!this._ws)throw Error("WebSocket undefined.");try{this._ws.send(e)}catch(e){if(e instanceof Error)return Promise.reject(e);return Promise.reject(Error("WebSocket send failed."))}return Promise.resolve()}onWebSocketClose(e,t){if(t!==this._ws)return;let n=`WebSocket closed ${this.server} (code: ${e.code})`,i=this.disconnectPromise?void 0:Error(n);i&&this.logger.warn("WebSocket closed unexpectedly"),this.logger.log(n),this._ws=void 0,this.transitionState(r.Disconnected,i)}onWebSocketError(e,t){t===this._ws&&this.logger.error("WebSocket error occurred.")}onWebSocketMessage(e,t){let n;if(t!==this._ws)return;let i=e.data;if(/^(\r\n)+$/.test(i)){this.clearKeepAliveTimeout(),!0===this.configuration.traceSip&&this.logger.log("Received WebSocket message with CRLF Keep Alive response");return}if(!i){this.logger.warn("Received empty message, discarding...");return}if("string"!=typeof i){try{n=new TextDecoder().decode(new Uint8Array(i))}catch(e){this.logger.error(e.toString()),this.logger.error("Received WebSocket binary message failed to be converted into string, message discarded");return}!0===this.configuration.traceSip&&this.logger.log("Received WebSocket binary message:\n\n"+n+"\n")}else n=i,!0===this.configuration.traceSip&&this.logger.log("Received WebSocket text message:\n\n"+n+"\n");if(this.state!==r.Connected){this.logger.warn("Received message while not connected, discarding...");return}if(this.onMessage)try{this.onMessage(n)}catch(e){throw this.logger.error(e.toString()),this.logger.error("Exception thrown by onMessage callback"),e}}onWebSocketOpen(e,t){t===this._ws&&this._state===r.Connecting&&(this.logger.log(`WebSocket opened ${this.server}`),this.transitionState(r.Connected))}transitionLoopDetectedError(e){let t="A state transition loop has been detected.";return t+=` An attempt to transition from ${this._state} to ${e} before the prior transition completed. Perhaps you are synchronously calling connect() or disconnect() from a callback or state change handler?`,this.logger.error(t),new o("Loop detected.")}transitionState(e,t){let n=()=>{throw Error(`Invalid state transition from ${this._state} to ${e}`)};if(this.transitioningState)throw this.transitionLoopDetectedError(e);switch(this.transitioningState=!0,this._state){case r.Connecting:e!==r.Connected&&e!==r.Disconnecting&&e!==r.Disconnected&&n();break;case r.Connected:e!==r.Disconnecting&&e!==r.Disconnected&&n();break;case r.Disconnecting:e!==r.Connecting&&e!==r.Disconnected&&n();break;case r.Disconnected:e!==r.Connecting&&n();break;default:throw Error("Unknown state.")}let i=this._state;this._state=e;let o=this.connectResolve,s=this.connectReject;i===r.Connecting&&(this.connectPromise=void 0,this.connectResolve=void 0,this.connectReject=void 0);let c=this.disconnectResolve,a=this.disconnectReject;if(i===r.Disconnecting&&(this.disconnectPromise=void 0,this.disconnectResolve=void 0,this.disconnectReject=void 0),this.connectTimeout&&(clearTimeout(this.connectTimeout),this.connectTimeout=void 0),this.logger.log(`Transitioned from ${i} to ${this._state}`),this._stateEventEmitter.emit(this._state),e===r.Connected&&(this.startSendingKeepAlives(),this.onConnect))try{this.onConnect()}catch(e){throw this.logger.error(e.toString()),this.logger.error("Exception thrown by onConnect callback"),e}if(i===r.Connected&&(this.stopSendingKeepAlives(),this.onDisconnect))try{t?this.onDisconnect(t):this.onDisconnect()}catch(e){throw this.logger.error(e.toString()),this.logger.error("Exception thrown by onDisconnect callback"),e}if(i===r.Connecting){if(!o)throw Error("Connect resolve undefined.");if(!s)throw Error("Connect reject undefined.");e===r.Connected?o():s(t||Error("Connect aborted."))}if(i===r.Disconnecting){if(!c)throw Error("Disconnect resolve undefined.");if(!a)throw Error("Disconnect reject undefined.");e===r.Disconnected?c():a(t||Error("Disconnect aborted."))}this.transitioningState=!1}clearKeepAliveTimeout(){this.keepAliveDebounceTimeout&&clearTimeout(this.keepAliveDebounceTimeout),this.keepAliveDebounceTimeout=void 0}sendKeepAlive(){return this.keepAliveDebounceTimeout?Promise.resolve():(this.keepAliveDebounceTimeout=setTimeout(()=>{this.clearKeepAliveTimeout()},1e3*this.configuration.keepAliveDebounce),this.send("\r\n\r\n"))}startSendingKeepAlives(){this.configuration.keepAliveInterval&&!this.keepAliveInterval&&(this.keepAliveInterval=setInterval(()=>{this.sendKeepAlive(),this.startSendingKeepAlives()},(e=>{let t=.8*e;return 1e3*(Math.random()*(e-t)+t)})(this.configuration.keepAliveInterval)))}stopSendingKeepAlives(){this.keepAliveInterval&&clearInterval(this.keepAliveInterval),this.keepAliveDebounceTimeout&&clearTimeout(this.keepAliveDebounceTimeout),this.keepAliveInterval=void 0,this.keepAliveDebounceTimeout=void 0}}c.defaultOptions={server:"",connectionTimeout:5,keepAliveInterval:0,keepAliveDebounce:10,traceSip:!0}}
//# sourceMappingURL=/dynamic/node_modules/sip.js/lib/platform/web/transport/876826e52d8d828f29b0ddf33a7f175e69b2bfdd.map
