function module(e,t,r){let s,i,n,a,o,g,h;r.export({Registerer:()=>d}),r.link("../grammar/grammar.js",{Grammar(e){s=e}},0),r.link("../grammar/uri.js",{equivalentURI(e){i=e},URI(e){n=e}},1),r.link("../core/messages/methods/constants.js",{C(e){a=e}},2),r.link("./emitter.js",{EmitterImpl(e){o=e}},3),r.link("./exceptions/request-pending.js",{RequestPendingError(e){g=e}},4),r.link("./registerer-state.js",{RegistererState(e){h=e}},5);class d{constructor(e,t={}){this.disposed=!1,this._contacts=[],this._retryAfter=void 0,this._state=h.Initial,this._waiting=!1,this._stateEventEmitter=new o,this._waitingEventEmitter=new o,this.userAgent=e;let r=e.configuration.uri.clone();if(r.user=void 0,this.options=Object.assign(Object.assign(Object.assign({},d.defaultOptions()),{registrar:r}),d.stripUndefinedProperties(t)),this.options.extraContactHeaderParams=(this.options.extraContactHeaderParams||[]).slice(),this.options.extraHeaders=(this.options.extraHeaders||[]).slice(),!this.options.registrar)throw Error("Registrar undefined.");if(this.options.registrar=this.options.registrar.clone(),this.options.regId&&!this.options.instanceId?this.options.instanceId=this.userAgent.instanceId:!this.options.regId&&this.options.instanceId&&(this.options.regId=1),this.options.instanceId&&-1===s.parse(this.options.instanceId,"uuid"))throw Error("Invalid instanceId.");if(this.options.regId&&this.options.regId<0)throw Error("Invalid regId.");let i=this.options.registrar,n=this.options.params&&this.options.params.fromUri||e.userAgentCore.configuration.aor,g=this.options.params&&this.options.params.toUri||e.configuration.uri,u=this.options.params||{},l=(t.extraHeaders||[]).slice();if(this.request=e.userAgentCore.makeOutgoingRequestMessage(a.REGISTER,i,n,g,u,l,void 0),this.expires=this.options.expires||d.defaultExpires,this.expires<0)throw Error("Invalid expires.");if(this.refreshFrequency=this.options.refreshFrequency||d.defaultRefreshFrequency,this.refreshFrequency<50||this.refreshFrequency>99)throw Error("Invalid refresh frequency. The value represents a percentage of the expiration time and should be between 50 and 99.");this.logger=e.getLogger("sip.Registerer"),this.options.logConfiguration&&(this.logger.log("Configuration:"),Object.keys(this.options).forEach(e=>{let t=this.options[e];"registrar"===e?this.logger.log("\xb7 "+e+": "+t):this.logger.log("\xb7 "+e+": "+JSON.stringify(t))})),this.id=this.request.callId+this.request.from.parameters.tag,this.userAgent._registerers[this.id]=this}static defaultOptions(){return{expires:d.defaultExpires,extraContactHeaderParams:[],extraHeaders:[],logConfiguration:!0,instanceId:"",params:{},regId:0,registrar:new n("sip","anonymous","anonymous.invalid"),refreshFrequency:d.defaultRefreshFrequency}}static stripUndefinedProperties(e){return Object.keys(e).reduce((t,r)=>(void 0!==e[r]&&(t[r]=e[r]),t),{})}get contacts(){return this._contacts.slice()}get retryAfter(){return this._retryAfter}get state(){return this._state}get stateChange(){return this._stateEventEmitter}dispose(){return this.disposed?Promise.resolve():(this.disposed=!0,this.logger.log(`Registerer ${this.id} in state ${this.state} is being disposed`),delete this.userAgent._registerers[this.id],new Promise(e=>{let t=()=>{if(!this.waiting&&this._state===h.Registered){this.stateChange.addListener(()=>{this.terminated(),e()},{once:!0}),this.unregister();return}this.terminated(),e()};this.waiting?this.waitingChange.addListener(()=>{t()},{once:!0}):t()}))}register(e={}){if(this.state===h.Terminated)throw this.stateError(),Error("Registerer terminated. Unable to register.");if(this.disposed)throw this.stateError(),Error("Registerer disposed. Unable to register.");if(this.waiting)return this.waitingWarning(),Promise.reject(new g("REGISTER request already in progress, waiting for final response"));e.requestOptions&&(this.options=Object.assign(Object.assign({},this.options),e.requestOptions));let t=(this.options.extraHeaders||[]).slice();return t.push("Contact: "+this.generateContactHeader(this.expires)),t.push("Allow: "+["ACK","CANCEL","INVITE","MESSAGE","BYE","OPTIONS","INFO","NOTIFY","REFER"].toString()),this.request.cseq++,this.request.setHeader("cseq",this.request.cseq+" REGISTER"),this.request.extraHeaders=t,this.waitingToggle(!0),Promise.resolve(this.userAgent.userAgentCore.register(this.request,{onAccept:t=>{let r,n;t.message.hasHeader("expires")&&(r=Number(t.message.getHeader("expires"))),this._contacts=t.message.getHeaders("contact");let a=this._contacts.length;if(!a){this.logger.error("No Contact header in response to REGISTER, dropping response."),this.unregistered();return}for(;a--;){if(!(n=t.message.parseHeader("contact",a)))throw Error("Contact undefined");if(this.userAgent.contact.pubGruu&&i(n.uri,this.userAgent.contact.pubGruu)){r=Number(n.getParam("expires"));break}if(""===this.userAgent.configuration.contactName){if(n.uri.user===this.userAgent.contact.uri.user){r=Number(n.getParam("expires"));break}}else if(i(n.uri,this.userAgent.contact.uri)){r=Number(n.getParam("expires"));break}n=void 0}if(void 0===n){this.logger.error("No Contact header pointing to us, dropping response"),this.unregistered(),this.waitingToggle(!1);return}if(void 0===r){this.logger.error("Contact pointing to us is missing expires parameter, dropping response"),this.unregistered(),this.waitingToggle(!1);return}if(n.hasParam("temp-gruu")){let e=n.getParam("temp-gruu");e&&(this.userAgent.contact.tempGruu=s.URIParse(e.replace(/"/g,"")))}if(n.hasParam("pub-gruu")){let e=n.getParam("pub-gruu");e&&(this.userAgent.contact.pubGruu=s.URIParse(e.replace(/"/g,"")))}this.registered(r),e.requestDelegate&&e.requestDelegate.onAccept&&e.requestDelegate.onAccept(t),this.waitingToggle(!1)},onProgress:t=>{e.requestDelegate&&e.requestDelegate.onProgress&&e.requestDelegate.onProgress(t)},onRedirect:t=>{this.logger.error("Redirect received. Not supported."),this.unregistered(),e.requestDelegate&&e.requestDelegate.onRedirect&&e.requestDelegate.onRedirect(t),this.waitingToggle(!1)},onReject:t=>{if(423===t.message.statusCode){if(!t.message.hasHeader("min-expires")){this.logger.error("423 response received for REGISTER without Min-Expires, dropping response"),this.unregistered(),this.waitingToggle(!1);return}this.expires=Number(t.message.getHeader("min-expires")),this.waitingToggle(!1),this.register();return}this.logger.warn(`Failed to register, status code ${t.message.statusCode}`);let r=NaN;if(500===t.message.statusCode||503===t.message.statusCode){let e=t.message.getHeader("retry-after");e&&(r=Number.parseInt(e,void 0))}this._retryAfter=isNaN(r)?void 0:r,this.unregistered(),e.requestDelegate&&e.requestDelegate.onReject&&e.requestDelegate.onReject(t),this._retryAfter=void 0,this.waitingToggle(!1)},onTrying:t=>{e.requestDelegate&&e.requestDelegate.onTrying&&e.requestDelegate.onTrying(t)}}))}unregister(e={}){if(this.state===h.Terminated)throw this.stateError(),Error("Registerer terminated. Unable to register.");if(this.disposed&&this.state!==h.Registered)throw this.stateError(),Error("Registerer disposed. Unable to register.");if(this.waiting)return this.waitingWarning(),Promise.reject(new g("REGISTER request already in progress, waiting for final response"));this._state===h.Registered||e.all||this.logger.warn("Not currently registered, but sending an unregister anyway.");let t=(e.requestOptions&&e.requestOptions.extraHeaders||[]).slice();return this.request.extraHeaders=t,e.all?(t.push("Contact: *"),t.push("Expires: 0")):t.push("Contact: "+this.generateContactHeader(0)),this.request.cseq++,this.request.setHeader("cseq",this.request.cseq+" REGISTER"),void 0!==this.registrationTimer&&(clearTimeout(this.registrationTimer),this.registrationTimer=void 0),this.waitingToggle(!0),Promise.resolve(this.userAgent.userAgentCore.register(this.request,{onAccept:t=>{this._contacts=t.message.getHeaders("contact"),this.unregistered(),e.requestDelegate&&e.requestDelegate.onAccept&&e.requestDelegate.onAccept(t),this.waitingToggle(!1)},onProgress:t=>{e.requestDelegate&&e.requestDelegate.onProgress&&e.requestDelegate.onProgress(t)},onRedirect:t=>{this.logger.error("Unregister redirected. Not currently supported."),this.unregistered(),e.requestDelegate&&e.requestDelegate.onRedirect&&e.requestDelegate.onRedirect(t),this.waitingToggle(!1)},onReject:t=>{this.logger.error(`Unregister rejected with status code ${t.message.statusCode}`),this.unregistered(),e.requestDelegate&&e.requestDelegate.onReject&&e.requestDelegate.onReject(t),this.waitingToggle(!1)},onTrying:t=>{e.requestDelegate&&e.requestDelegate.onTrying&&e.requestDelegate.onTrying(t)}}))}clearTimers(){void 0!==this.registrationTimer&&(clearTimeout(this.registrationTimer),this.registrationTimer=void 0),void 0!==this.registrationExpiredTimer&&(clearTimeout(this.registrationExpiredTimer),this.registrationExpiredTimer=void 0)}generateContactHeader(e){let t=this.userAgent.contact.toString({register:!0});return this.options.regId&&this.options.instanceId&&(t+=";reg-id="+this.options.regId+';+sip.instance="<urn:uuid:'+this.options.instanceId+'>"'),this.options.extraContactHeaderParams&&this.options.extraContactHeaderParams.forEach(e=>{t+=";"+e}),t+=";expires="+e}registered(e){this.clearTimers(),this.registrationTimer=setTimeout(()=>{this.registrationTimer=void 0,this.register()},this.refreshFrequency/100*e*1e3),this.registrationExpiredTimer=setTimeout(()=>{this.logger.warn("Registration expired"),this.unregistered()},1e3*e),this._state!==h.Registered&&this.stateTransition(h.Registered)}unregistered(){this.clearTimers(),this._state!==h.Unregistered&&this.stateTransition(h.Unregistered)}terminated(){this.clearTimers(),this._state!==h.Terminated&&this.stateTransition(h.Terminated)}stateTransition(e){let t=()=>{throw Error(`Invalid state transition from ${this._state} to ${e}`)};switch(this._state){case h.Initial:e!==h.Registered&&e!==h.Unregistered&&e!==h.Terminated&&t();break;case h.Registered:e!==h.Unregistered&&e!==h.Terminated&&t();break;case h.Unregistered:e!==h.Registered&&e!==h.Terminated&&t();break;case h.Terminated:t();break;default:throw Error("Unrecognized state.")}this._state=e,this.logger.log(`Registration transitioned to state ${this._state}`),this._stateEventEmitter.emit(this._state),e===h.Terminated&&this.dispose()}get waiting(){return this._waiting}get waitingChange(){return this._waitingEventEmitter}waitingToggle(e){if(this._waiting===e)throw Error(`Invalid waiting transition from ${this._waiting} to ${e}`);this._waiting=e,this.logger.log(`Waiting toggled to ${this._waiting}`),this._waitingEventEmitter.emit(this._waiting)}waitingWarning(){let e="An attempt was made to send a REGISTER request while a prior one was still in progress.";e+=" RFC 3261 requires UAs MUST NOT send a new registration until they have received a final response from the registrar for the previous one or the previous REGISTER request has timed out. Note that if the transport disconnects, you still must wait for the prior request to time out before sending a new REGISTER request or alternatively dispose of the current Registerer and create a new Registerer.",this.logger.warn(e)}stateError(){let e=this.state===h.Terminated?"is in 'Terminated' state":"has been disposed",t=`An attempt was made to send a REGISTER request when the Registerer ${e}.`;t+=" The Registerer transitions to 'Terminated' when Registerer.dispose() is called. Perhaps you called UserAgent.stop() which dipsoses of all Registerers?",this.logger.error(t)}}d.defaultExpires=600,d.defaultRefreshFrequency=99}
//# sourceMappingURL=/dynamic/node_modules/sip.js/lib/api/092183441810f1edc685b16a7ca86bdd946f0cfd.map
