import ts from 'typescript';
import { ExpressionFactory } from '../../../factories/ExpressionFactory.mjs';
import { LiteralFactory } from '../../../factories/LiteralFactory.mjs';
import { StatementFactory } from '../../../factories/StatementFactory.mjs';
import { TransformerError } from '../../TransformerError.mjs';
import { LlmApplicationTransformer } from './LlmApplicationTransformer.mjs';

var LlmControllerTransformer;
(function (LlmControllerTransformer) {
    LlmControllerTransformer.transform = (props) => {
        const dec = LlmApplicationTransformer.decompose("application", props);
        if (dec === null)
            return props.expression;
        else if (props.expression.arguments[0] === undefined)
            throw new TransformerError({
                code: `typia.llm.controller`,
                message: `no identifier name.`,
            });
        else if (props.expression.arguments[1] === undefined)
            throw new TransformerError({
                code: `typia.llm.controller`,
                message: `no executor.`,
            });
        const property = ts.factory.createAsExpression(LiteralFactory.write(dec.application), props.context.importer.type({
            file: "@samchon/openapi",
            name: "ILlmApplication",
            arguments: [
                ts.factory.createLiteralTypeNode(ts.factory.createStringLiteral(dec.application.model)),
            ],
        }));
        const value = ts.factory.createObjectLiteralExpression([
            ts.factory.createPropertyAssignment("protocol", ts.factory.createStringLiteral("class")),
            ts.factory.createPropertyAssignment("name", props.expression.arguments[0]),
            ts.factory.createPropertyAssignment("execute", props.expression.arguments[1]),
            ts.factory.createShorthandPropertyAssignment("application"),
        ], true);
        return ExpressionFactory.selfCall(ts.factory.createBlock([
            StatementFactory.constant({
                name: "application",
                value: property,
            }),
            ...(props.expression.arguments?.[2] !== undefined
                ? [
                    ts.factory.createExpressionStatement(LlmApplicationTransformer.finalize({
                        context: props.context,
                        value: ts.factory.createIdentifier("application"),
                        argument: props.expression.arguments[2],
                        equals: dec.config?.equals,
                        model: dec.application.model,
                    })),
                ]
                : []),
            ts.factory.createReturnStatement(value),
        ], true), props.context.importer.type({
            file: "@samchon/openapi",
            name: "ILlmController",
            arguments: [
                ts.factory.createLiteralTypeNode(ts.factory.createStringLiteral(dec.application.model)),
                dec.node,
            ],
        }));
    };
})(LlmControllerTransformer || (LlmControllerTransformer = {}));

export { LlmControllerTransformer };
//# sourceMappingURL=LlmControllerTransformer.mjs.map
