"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LlmControllerTransformer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../../../factories/ExpressionFactory");
const LiteralFactory_1 = require("../../../factories/LiteralFactory");
const StatementFactory_1 = require("../../../factories/StatementFactory");
const TransformerError_1 = require("../../TransformerError");
const LlmApplicationTransformer_1 = require("./LlmApplicationTransformer");
var LlmControllerTransformer;
(function (LlmControllerTransformer) {
    LlmControllerTransformer.transform = (props) => {
        var _a, _b;
        const dec = LlmApplicationTransformer_1.LlmApplicationTransformer.decompose("application", props);
        if (dec === null)
            return props.expression;
        else if (props.expression.arguments[0] === undefined)
            throw new TransformerError_1.TransformerError({
                code: `typia.llm.controller`,
                message: `no identifier name.`,
            });
        else if (props.expression.arguments[1] === undefined)
            throw new TransformerError_1.TransformerError({
                code: `typia.llm.controller`,
                message: `no executor.`,
            });
        const property = typescript_1.default.factory.createAsExpression(LiteralFactory_1.LiteralFactory.write(dec.application), props.context.importer.type({
            file: "@samchon/openapi",
            name: "ILlmApplication",
            arguments: [
                typescript_1.default.factory.createLiteralTypeNode(typescript_1.default.factory.createStringLiteral(dec.application.model)),
            ],
        }));
        const value = typescript_1.default.factory.createObjectLiteralExpression([
            typescript_1.default.factory.createPropertyAssignment("protocol", typescript_1.default.factory.createStringLiteral("class")),
            typescript_1.default.factory.createPropertyAssignment("name", props.expression.arguments[0]),
            typescript_1.default.factory.createPropertyAssignment("execute", props.expression.arguments[1]),
            typescript_1.default.factory.createShorthandPropertyAssignment("application"),
        ], true);
        return ExpressionFactory_1.ExpressionFactory.selfCall(typescript_1.default.factory.createBlock([
            StatementFactory_1.StatementFactory.constant({
                name: "application",
                value: property,
            }),
            ...(((_a = props.expression.arguments) === null || _a === void 0 ? void 0 : _a[2]) !== undefined
                ? [
                    typescript_1.default.factory.createExpressionStatement(LlmApplicationTransformer_1.LlmApplicationTransformer.finalize({
                        context: props.context,
                        value: typescript_1.default.factory.createIdentifier("application"),
                        argument: props.expression.arguments[2],
                        equals: (_b = dec.config) === null || _b === void 0 ? void 0 : _b.equals,
                        model: dec.application.model,
                    })),
                ]
                : []),
            typescript_1.default.factory.createReturnStatement(value),
        ], true), props.context.importer.type({
            file: "@samchon/openapi",
            name: "ILlmController",
            arguments: [
                typescript_1.default.factory.createLiteralTypeNode(typescript_1.default.factory.createStringLiteral(dec.application.model)),
                dec.node,
            ],
        }));
    };
})(LlmControllerTransformer || (exports.LlmControllerTransformer = LlmControllerTransformer = {}));
//# sourceMappingURL=LlmControllerTransformer.js.map