import path from 'path';
import { FunctionalAssertFunctionProgrammer } from '../programmers/functional/FunctionalAssertFunctionProgrammer.mjs';
import { FunctionalAssertParametersProgrammer } from '../programmers/functional/FunctionalAssertParametersProgrammer.mjs';
import { FunctionAssertReturnProgrammer } from '../programmers/functional/FunctionalAssertReturnProgrammer.mjs';
import { FunctionalIsFunctionProgrammer } from '../programmers/functional/FunctionalIsFunctionProgrammer.mjs';
import { FunctionalIsParametersProgrammer } from '../programmers/functional/FunctionalIsParametersProgrammer.mjs';
import { FunctionalIsReturnProgrammer } from '../programmers/functional/FunctionalIsReturnProgrammer.mjs';
import { FunctionalValidateFunctionProgrammer } from '../programmers/functional/FunctionalValidateFunctionProgrammer.mjs';
import { FunctionalValidateParametersProgrammer } from '../programmers/functional/FunctionalValidateParametersProgrammer.mjs';
import { FunctionalValidateReturnProgrammer } from '../programmers/functional/FunctionalValidateReturnProgrammer.mjs';
import { FunctionalGenericTransformer } from './features/functional/FunctionalGenericTransformer.mjs';
import { NamingConvention } from '../utils/NamingConvention.mjs';
import { AssertTransformer } from './features/AssertTransformer.mjs';
import { CreateAssertTransformer } from './features/CreateAssertTransformer.mjs';
import { CreateIsTransformer } from './features/CreateIsTransformer.mjs';
import { CreateRandomTransformer } from './features/CreateRandomTransformer.mjs';
import { CreateValidateTransformer } from './features/CreateValidateTransformer.mjs';
import { IsTransformer } from './features/IsTransformer.mjs';
import { RandomTransformer } from './features/RandomTransformer.mjs';
import { ValidateTransformer } from './features/ValidateTransformer.mjs';
import { CreateHttpAssertFormDataTransformer } from './features/http/CreateHttpAssertFormDataTransformer.mjs';
import { CreateHttpAssertHeadersTransformer } from './features/http/CreateHttpAssertHeadersTransformer.mjs';
import { CreateHttpAssertQueryTransformer } from './features/http/CreateHttpAssertQueryTransformer.mjs';
import { CreateHttpFormDataTransformer } from './features/http/CreateHttpFormDataTransformer.mjs';
import { CreateHttpHeadersTransformer } from './features/http/CreateHttpHeadersTransformer.mjs';
import { CreateHttpIsFormDataTransformer } from './features/http/CreateHttpIsFormDataTransformer.mjs';
import { CreateHttpIsHeadersTransformer } from './features/http/CreateHttpIsHeadersTransformer.mjs';
import { CreateHttpIsQueryTransformer } from './features/http/CreateHttpIsQueryTransformer.mjs';
import { CreateHttpParameterTransformer } from './features/http/CreateHttpParameterTransformer.mjs';
import { CreateHttpQueryTransformer } from './features/http/CreateHttpQueryTransformer.mjs';
import { CreateHttpValidateFormDataTransformer } from './features/http/CreateHttpValidateFormDataTransformer.mjs';
import { CreateHttpValidateHeadersTransformer } from './features/http/CreateHttpValidateHeadersTransformer.mjs';
import { CreateHttpValidateQueryTransformer } from './features/http/CreateHttpValidateQueryTransformer.mjs';
import { HttpAssertFormDataTransformer } from './features/http/HttpAssertFormDataTransformer.mjs';
import { HttpAssertHeadersTransformer } from './features/http/HttpAssertHeadersTransformer.mjs';
import { HttpAssertQueryTransformer } from './features/http/HttpAssertQueryTransformer.mjs';
import { HttpFormDataTransformer } from './features/http/HttpFormDataTransformer.mjs';
import { HttpHeadersTransformer } from './features/http/HttpHeadersTransformer.mjs';
import { HttpIsFormDataTransformer } from './features/http/HttpIsFormDataTransformer.mjs';
import { HttpIsHeadersTransformer } from './features/http/HttpIsHeadersTransformer.mjs';
import { HttpIsQueryTransformer } from './features/http/HttpIsQueryTransformer.mjs';
import { HttpParameterTransformer } from './features/http/HttpParameterTransformer.mjs';
import { HttpQueryTransformer } from './features/http/HttpQueryTransformer.mjs';
import { HttpValidateFormDataTransformer } from './features/http/HttpValidateFormDataTransformer.mjs';
import { HttpValidateHeadersTransformer } from './features/http/HttpValidateHeadersTransformer.mjs';
import { HttpValidateQueryTransformer } from './features/http/HttpValidateQueryTransformer.mjs';
import { JsonAssertParseTransformer } from './features/json/JsonAssertParseTransformer.mjs';
import { JsonAssertStringifyTransformer } from './features/json/JsonAssertStringifyTransformer.mjs';
import { JsonCreateAssertParseTransformer } from './features/json/JsonCreateAssertParseTransformer.mjs';
import { JsonCreateAssertStringifyTransformer } from './features/json/JsonCreateAssertStringifyTransformer.mjs';
import { JsonCreateIsParseTransformer } from './features/json/JsonCreateIsParseTransformer.mjs';
import { JsonCreateIsStringifyTransformer } from './features/json/JsonCreateIsStringifyTransformer.mjs';
import { JsonCreateStringifyTransformer } from './features/json/JsonCreateStringifyTransformer.mjs';
import { JsonCreateValidateParseTransformer } from './features/json/JsonCreateValidateParseTransformer.mjs';
import { JsonCreateValidateStringifyTransformer } from './features/json/JsonCreateValidateStringifyProgrammer.mjs';
import { JsonIsParseTransformer } from './features/json/JsonIsParseTransformer.mjs';
import { JsonIsStringifyTransformer } from './features/json/JsonIsStringifyTransformer.mjs';
import { JsonSchemaTransformer } from './features/json/JsonSchemaTransformer.mjs';
import { JsonSchemasTransformer } from './features/json/JsonSchemasTransformer.mjs';
import { JsonStringifyTransformer } from './features/json/JsonStringifyTransformer.mjs';
import { JsonValidateParseTransformer } from './features/json/JsonValidateParseTransformer.mjs';
import { JsonValidateStringifyTransformer } from './features/json/JsonValidateStringifyTransformer.mjs';
import { LlmApplicationTransformer } from './features/llm/LlmApplicationTransformer.mjs';
import { LlmControllerTransformer } from './features/llm/LlmControllerTransformer.mjs';
import { LlmParametersTransformer } from './features/llm/LlmParametersTransformer.mjs';
import { LlmSchemaTransformer } from './features/llm/LlmSchemaTransformer.mjs';
import { MiscAssertCloneTransformer } from './features/misc/MiscAssertCloneTransformer.mjs';
import { MiscAssertPruneTransformer } from './features/misc/MiscAssertPruneTransformer.mjs';
import { MiscCloneTransformer } from './features/misc/MiscCloneTransformer.mjs';
import { MiscCreateAssertCloneTransformer } from './features/misc/MiscCreateAssertCloneTransformer.mjs';
import { MiscCreateAssertPruneTransformer } from './features/misc/MiscCreateAssertPruneTransformer.mjs';
import { MiscCreateCloneTransformer } from './features/misc/MiscCreateCloneTransformer.mjs';
import { MiscCreateIsCloneTransformer } from './features/misc/MiscCreateIsCloneTransformer.mjs';
import { MiscCreateIsPruneTransformer } from './features/misc/MiscCreateIsPruneTransformer.mjs';
import { MiscCreatePruneTransformer } from './features/misc/MiscCreatePruneTransformer.mjs';
import { MiscCreateValidateCloneTransformer } from './features/misc/MiscCreateValidateCloneTransformer.mjs';
import { MiscCreateValidatePruneTransformer } from './features/misc/MiscCreateValidatePruneTransformer.mjs';
import { MiscIsCloneTransformer } from './features/misc/MiscIsCloneTransformer.mjs';
import { MiscIsPruneTransformer } from './features/misc/MiscIsPruneTransformer.mjs';
import { MiscLiteralsTransformer } from './features/misc/MiscLiteralsTransformer.mjs';
import { MiscPruneTransformer } from './features/misc/MiscPruneTransformer.mjs';
import { MiscValidateCloneTransformer } from './features/misc/MiscValidateCloneTransformer.mjs';
import { MiscValidatePruneTransformer } from './features/misc/MiscValidatePruneTransformer.mjs';
import { NotationAssertGeneralTransformer } from './features/notations/NotationAssertGeneralTransformer.mjs';
import { NotationCreateAssertGeneralTransformer } from './features/notations/NotationCreateAssertGeneralTransformer.mjs';
import { NotationCreateGeneralTransformer } from './features/notations/NotationCreateGeneralTransformer.mjs';
import { NotationCreateIsGeneralTransformer } from './features/notations/NotationCreateIsGeneralTransformer.mjs';
import { NotationCreateValidateGeneralTransformer } from './features/notations/NotationCreateValidateGeneralTransformer.mjs';
import { NotationGeneralTransformer } from './features/notations/NotationGeneralTransformer.mjs';
import { NotationIsGeneralTransformer } from './features/notations/NotationIsGeneralTransformer.mjs';
import { NotationValidateGeneralTransformer } from './features/notations/NotationValidateGeneralTransformer.mjs';
import { ProtobufAssertDecodeTransformer } from './features/protobuf/ProtobufAssertDecodeTransformer.mjs';
import { ProtobufAssertEncodeTransformer } from './features/protobuf/ProtobufAssertEncodeTransformer.mjs';
import { ProtobufCreateAssertDecodeTransformer } from './features/protobuf/ProtobufCreateAssertDecodeTransformer.mjs';
import { ProtobufCreateAssertEncodeTransformer } from './features/protobuf/ProtobufCreateAssertEncodeTransformer.mjs';
import { ProtobufCreateDecodeTransformer } from './features/protobuf/ProtobufCreateDecodeTransformer.mjs';
import { ProtobufCreateEncodeTransformer } from './features/protobuf/ProtobufCreateEncodeTransformer.mjs';
import { ProtobufCreateIsDecodeTransformer } from './features/protobuf/ProtobufCreateIsDecodeTransformer.mjs';
import { ProtobufCreateIsEncodeTransformer } from './features/protobuf/ProtobufCreateIsEncodeTransformer.mjs';
import { ProtobufCreateValidateDecodeTransformer } from './features/protobuf/ProtobufCreateValidateDecodeTransformer.mjs';
import { ProtobufCreateValidateEncodeTransformer } from './features/protobuf/ProtobufCreateValidateEncodeTransformer.mjs';
import { ProtobufDecodeTransformer } from './features/protobuf/ProtobufDecodeTransformer.mjs';
import { ProtobufEncodeTransformer } from './features/protobuf/ProtobufEncodeTransformer.mjs';
import { ProtobufIsDecodeTransformer } from './features/protobuf/ProtobufIsDecodeTransformer.mjs';
import { ProtobufIsEncodeTransformer } from './features/protobuf/ProtobufIsEncodeTransformer.mjs';
import { ProtobufMessageTransformer } from './features/protobuf/ProtobufMessageTransformer.mjs';
import { ProtobufValidateDecodeTransformer } from './features/protobuf/ProtobufValidateDecodeTransformer.mjs';
import { ProtobufValidateEncodeTransformer } from './features/protobuf/ProtobufValidateEncodeTransformer.mjs';
import { ReflectMetadataTransformer } from './features/reflect/ReflectMetadataTransformer.mjs';
import { ReflectNameTransformer } from './features/reflect/ReflectNameTransformer.mjs';

var CallExpressionTransformer;
(function (CallExpressionTransformer) {
    CallExpressionTransformer.transform = (props) => {
        //----
        // VALIDATIONS
        //----
        // SIGNATURE DECLARATION
        const declaration = props.context.checker.getResolvedSignature(props.expression)?.declaration;
        if (!declaration)
            return props.expression;
        // FILE PATH
        const location = path.resolve(declaration.getSourceFile().fileName);
        if (isTarget(location) === false)
            return props.expression;
        //----
        // TRANSFORMATION
        //----
        // FUNCTION NAME
        const module = location.split(path.sep).at(-1).split(".")[0];
        const { name } = props.context.checker.getTypeAtLocation(declaration).symbol;
        // FIND TRANSFORMER
        const functor = FUNCTORS[module]?.[name];
        if (functor === undefined)
            return props.expression;
        // RETURNS WITH TRANSFORMATION
        const result = functor()({
            context: props.context,
            modulo: props.expression.expression,
            expression: props.expression,
        });
        return result ?? props.expression;
    };
    const isTarget = (location) => {
        const files = Object.keys(FUNCTORS);
        return files.some((f) => location.includes(path.join("typia", "lib", `${f}.d.ts`)));
    };
})(CallExpressionTransformer || (CallExpressionTransformer = {}));
const FUNCTORS = {
    module: {
        // BASIC
        assert: () => AssertTransformer.transform({ equals: false, guard: false }),
        assertGuard: () => AssertTransformer.transform({ equals: false, guard: true }),
        assertType: () => AssertTransformer.transform({ equals: false, guard: false }),
        is: () => IsTransformer.transform({ equals: false }),
        validate: () => ValidateTransformer.transform({ equals: false }),
        // STRICT
        assertEquals: () => AssertTransformer.transform({ equals: true, guard: false }),
        assertGuardEquals: () => AssertTransformer.transform({ equals: true, guard: true }),
        equals: () => IsTransformer.transform({ equals: true }),
        validateEquals: () => ValidateTransformer.transform({ equals: true }),
        // RANDOM + INTERNAL
        random: () => RandomTransformer.transform,
        metadata: () => ReflectMetadataTransformer.transform,
        // FACTORIES
        createAssert: () => CreateAssertTransformer.transform({ equals: false, guard: false }),
        createAssertGuard: () => CreateAssertTransformer.transform({ equals: false, guard: true }),
        createAssertType: () => CreateAssertTransformer.transform({ equals: false, guard: false }),
        createIs: () => CreateIsTransformer.transform({ equals: false }),
        createValidate: () => CreateValidateTransformer.transform({
            equals: false,
            standardSchema: true,
        }),
        createAssertEquals: () => CreateAssertTransformer.transform({ equals: true, guard: false }),
        createAssertGuardEquals: () => CreateAssertTransformer.transform({ equals: true, guard: true }),
        createEquals: () => CreateIsTransformer.transform({ equals: true }),
        createValidateEquals: () => CreateValidateTransformer.transform({
            equals: true,
            standardSchema: true,
        }),
        createRandom: () => CreateRandomTransformer.transform,
    },
    functional: {
        // ASSERTIONS
        assertFunction: () => FunctionalGenericTransformer.transform({
            method: "assertFunction",
            config: {
                equals: false,
            },
            programmer: FunctionalAssertFunctionProgrammer.write,
        }),
        assertParameters: () => FunctionalGenericTransformer.transform({
            method: "assertParameters",
            config: {
                equals: false,
            },
            programmer: FunctionalAssertParametersProgrammer.write,
        }),
        assertReturn: () => FunctionalGenericTransformer.transform({
            method: "assertReturn",
            config: {
                equals: false,
            },
            programmer: FunctionAssertReturnProgrammer.write,
        }),
        assertEqualsFunction: () => FunctionalGenericTransformer.transform({
            method: "assertEqualsFunction",
            config: {
                equals: true,
            },
            programmer: FunctionalAssertFunctionProgrammer.write,
        }),
        assertEqualsParameters: () => FunctionalGenericTransformer.transform({
            method: "assertEqualsParameters",
            config: {
                equals: true,
            },
            programmer: FunctionalAssertParametersProgrammer.write,
        }),
        assertEqualsReturn: () => FunctionalGenericTransformer.transform({
            method: "assertEqualsReturn",
            config: {
                equals: true,
            },
            programmer: FunctionAssertReturnProgrammer.write,
        }),
        // IS
        isFunction: () => FunctionalGenericTransformer.transform({
            method: "isFunction",
            config: {
                equals: false,
            },
            programmer: FunctionalIsFunctionProgrammer.write,
        }),
        isParameters: () => FunctionalGenericTransformer.transform({
            method: "isParameters",
            config: {
                equals: false,
            },
            programmer: FunctionalIsParametersProgrammer.write,
        }),
        isReturn: () => FunctionalGenericTransformer.transform({
            method: "isReturn",
            config: {
                equals: false,
            },
            programmer: FunctionalIsReturnProgrammer.write,
        }),
        equalsFunction: () => FunctionalGenericTransformer.transform({
            method: "equalsFunction",
            config: {
                equals: true,
            },
            programmer: FunctionalIsFunctionProgrammer.write,
        }),
        equalsParameters: () => FunctionalGenericTransformer.transform({
            method: "equalsParameters",
            config: {
                equals: true,
            },
            programmer: FunctionalIsParametersProgrammer.write,
        }),
        equalsReturn: () => FunctionalGenericTransformer.transform({
            method: "equalsReturn",
            config: {
                equals: true,
            },
            programmer: FunctionalIsReturnProgrammer.write,
        }),
        // VALIDATIONS
        validateFunction: () => FunctionalGenericTransformer.transform({
            method: "validateFunction",
            config: {
                equals: false,
            },
            programmer: FunctionalValidateFunctionProgrammer.write,
        }),
        validateParameters: () => FunctionalGenericTransformer.transform({
            method: "validateParameters",
            config: {
                equals: false,
            },
            programmer: FunctionalValidateParametersProgrammer.write,
        }),
        validateReturn: () => FunctionalGenericTransformer.transform({
            method: "validateReturn",
            config: {
                equals: false,
            },
            programmer: FunctionalValidateReturnProgrammer.write,
        }),
        validateEqualsFunction: () => FunctionalGenericTransformer.transform({
            method: "validateEqualsFunction",
            config: {
                equals: true,
            },
            programmer: FunctionalValidateFunctionProgrammer.write,
        }),
        validateEqualsParameters: () => FunctionalGenericTransformer.transform({
            method: "validateEqualsParameters",
            config: {
                equals: true,
            },
            programmer: FunctionalValidateParametersProgrammer.write,
        }),
        validateEqualsReturn: () => FunctionalGenericTransformer.transform({
            method: "validateEqualsReturn",
            config: {
                equals: true,
            },
            programmer: FunctionalValidateReturnProgrammer.write,
        }),
    },
    http: {
        // FORM-DATA
        formData: () => HttpFormDataTransformer.transform,
        isFormData: () => HttpIsFormDataTransformer.transform,
        assertFormData: () => HttpAssertFormDataTransformer.transform,
        validateFormData: () => HttpValidateFormDataTransformer.transform,
        // HEADERS
        headers: () => HttpHeadersTransformer.transform,
        isHeaders: () => HttpIsHeadersTransformer.transform,
        assertHeaders: () => HttpAssertHeadersTransformer.transform,
        validateHeaders: () => HttpValidateHeadersTransformer.transform,
        // PARAMETER
        parameter: () => HttpParameterTransformer.transform,
        // QUERY
        query: () => HttpQueryTransformer.transform,
        isQuery: () => HttpIsQueryTransformer.transform,
        assertQuery: () => HttpAssertQueryTransformer.transform,
        validateQuery: () => HttpValidateQueryTransformer.transform,
        // FACTORIES
        createFormData: () => CreateHttpFormDataTransformer.transform,
        createIsFormData: () => CreateHttpIsFormDataTransformer.transform,
        createAssertFormData: () => CreateHttpAssertFormDataTransformer.transform,
        createValidateFormData: () => CreateHttpValidateFormDataTransformer.transform,
        createHeaders: () => CreateHttpHeadersTransformer.transform,
        createIsHeaders: () => CreateHttpIsHeadersTransformer.transform,
        createAssertHeaders: () => CreateHttpAssertHeadersTransformer.transform,
        createValidateHeaders: () => CreateHttpValidateHeadersTransformer.transform,
        createParameter: () => CreateHttpParameterTransformer.transform,
        createQuery: () => CreateHttpQueryTransformer.transform,
        createIsQuery: () => CreateHttpIsQueryTransformer.transform,
        createAssertQuery: () => CreateHttpAssertQueryTransformer.transform,
        createValidateQuery: () => CreateHttpValidateQueryTransformer.transform,
    },
    llm: {
        controller: () => LlmControllerTransformer.transform,
        applicationOfValidate: () => LlmApplicationTransformer.transform,
        application: () => LlmApplicationTransformer.transform,
        parameters: () => LlmParametersTransformer.transform,
        schema: () => LlmSchemaTransformer.transform,
    },
    json: {
        // METADATA
        schemas: () => JsonSchemasTransformer.transform,
        schema: () => JsonSchemaTransformer.transform,
        // PARSER
        isParse: () => JsonIsParseTransformer.transform,
        assertParse: () => JsonAssertParseTransformer.transform,
        validateParse: () => JsonValidateParseTransformer.transform,
        // STRINGIFY
        stringify: () => JsonStringifyTransformer.transform,
        assertStringify: () => JsonAssertStringifyTransformer.transform,
        isStringify: () => JsonIsStringifyTransformer.transform,
        validateStringify: () => JsonValidateStringifyTransformer.transform,
        // FACTORIES
        createIsParse: () => JsonCreateIsParseTransformer.transform,
        createAssertParse: () => JsonCreateAssertParseTransformer.transform,
        createValidateParse: () => JsonCreateValidateParseTransformer.transform,
        createStringify: () => JsonCreateStringifyTransformer.transform,
        createAssertStringify: () => JsonCreateAssertStringifyTransformer.transform,
        createIsStringify: () => JsonCreateIsStringifyTransformer.transform,
        createValidateStringify: () => JsonCreateValidateStringifyTransformer.transform,
    },
    protobuf: {
        // SCHEMA
        message: () => ProtobufMessageTransformer.transform,
        // ENCODE
        encode: () => ProtobufEncodeTransformer.transform,
        assertEncode: () => ProtobufAssertEncodeTransformer.transform,
        isEncode: () => ProtobufIsEncodeTransformer.transform,
        validateEncode: () => ProtobufValidateEncodeTransformer.transform,
        // DECODE
        decode: () => ProtobufDecodeTransformer.transform,
        assertDecode: () => ProtobufAssertDecodeTransformer.transform,
        isDecode: () => ProtobufIsDecodeTransformer.transform,
        validateDecode: () => ProtobufValidateDecodeTransformer.transform,
        // FACTORIES
        createEncode: () => ProtobufCreateEncodeTransformer.transform,
        createAssertEncode: () => ProtobufCreateAssertEncodeTransformer.transform,
        createIsEncode: () => ProtobufCreateIsEncodeTransformer.transform,
        createValidateEncode: () => ProtobufCreateValidateEncodeTransformer.transform,
        createDecode: () => ProtobufCreateDecodeTransformer.transform,
        createAssertDecode: () => ProtobufCreateAssertDecodeTransformer.transform,
        createIsDecode: () => ProtobufCreateIsDecodeTransformer.transform,
        createValidateDecode: () => ProtobufCreateValidateDecodeTransformer.transform,
    },
    reflect: {
        metadata: () => ReflectMetadataTransformer.transform,
        name: () => ReflectNameTransformer.transform,
    },
    misc: {
        literals: () => MiscLiteralsTransformer.transform,
        // CLONE
        clone: () => MiscCloneTransformer.transform,
        assertClone: () => MiscAssertCloneTransformer.transform,
        isClone: () => MiscIsCloneTransformer.transform,
        validateClone: () => MiscValidateCloneTransformer.transform,
        // PRUNE
        prune: () => MiscPruneTransformer.transform,
        assertPrune: () => MiscAssertPruneTransformer.transform,
        isPrune: () => MiscIsPruneTransformer.transform,
        validatePrune: () => MiscValidatePruneTransformer.transform,
        // FACTORIES
        createClone: () => MiscCreateCloneTransformer.transform,
        createAssertClone: () => MiscCreateAssertCloneTransformer.transform,
        createIsClone: () => MiscCreateIsCloneTransformer.transform,
        createValidateClone: () => MiscCreateValidateCloneTransformer.transform,
        createPrune: () => MiscCreatePruneTransformer.transform,
        createAssertPrune: () => MiscCreateAssertPruneTransformer.transform,
        createIsPrune: () => MiscCreateIsPruneTransformer.transform,
        createValidatePrune: () => MiscCreateValidatePruneTransformer.transform,
    },
    notations: {
        // CAMEL
        camel: () => NotationGeneralTransformer.transform(NamingConvention.camel),
        assertCamel: () => NotationAssertGeneralTransformer.transform(NamingConvention.camel),
        isCamel: () => NotationIsGeneralTransformer.transform(NamingConvention.camel),
        validateCamel: () => NotationValidateGeneralTransformer.transform(NamingConvention.camel),
        // PASCAL
        pascal: () => NotationGeneralTransformer.transform(NamingConvention.pascal),
        assertPascal: () => NotationAssertGeneralTransformer.transform(NamingConvention.pascal),
        isPascal: () => NotationIsGeneralTransformer.transform(NamingConvention.pascal),
        validatePascal: () => NotationValidateGeneralTransformer.transform(NamingConvention.pascal),
        // SNAKE
        snake: () => NotationGeneralTransformer.transform(NamingConvention.snake),
        assertSnake: () => NotationAssertGeneralTransformer.transform(NamingConvention.snake),
        isSnake: () => NotationIsGeneralTransformer.transform(NamingConvention.snake),
        validateSnake: () => NotationValidateGeneralTransformer.transform(NamingConvention.snake),
        // FACTORIES
        createCamel: () => NotationCreateGeneralTransformer.transform(NamingConvention.camel),
        createAssertCamel: () => NotationCreateAssertGeneralTransformer.transform(NamingConvention.camel),
        createIsCamel: () => NotationCreateIsGeneralTransformer.transform(NamingConvention.camel),
        createValidateCamel: () => NotationCreateValidateGeneralTransformer.transform(NamingConvention.camel),
        createPascal: () => NotationCreateGeneralTransformer.transform(NamingConvention.pascal),
        createAssertPascal: () => NotationCreateAssertGeneralTransformer.transform(NamingConvention.pascal),
        createIsPascal: () => NotationCreateIsGeneralTransformer.transform(NamingConvention.pascal),
        createValidatePascal: () => NotationCreateValidateGeneralTransformer.transform(NamingConvention.pascal),
        createSnake: () => NotationCreateGeneralTransformer.transform(NamingConvention.snake),
        createAssertSnake: () => NotationCreateAssertGeneralTransformer.transform(NamingConvention.snake),
        createIsSnake: () => NotationCreateIsGeneralTransformer.transform(NamingConvention.snake),
        createValidateSnake: () => NotationCreateValidateGeneralTransformer.transform(NamingConvention.snake),
    },
};

export { CallExpressionTransformer };
//# sourceMappingURL=CallExpressionTransformer.mjs.map
