import { Metadata } from './Metadata.mjs';

class MetadataParameter {
    name;
    type;
    description;
    jsDocTags;
    tsType;
    constructor(props) {
        this.name = props.name;
        this.type = props.type;
        this.description = props.description;
        this.jsDocTags = props.jsDocTags;
        this.tsType = props.tsType;
    }
    /** @internal */
    static create(props) {
        return new MetadataParameter(props);
    }
    static from(json, dict) {
        return MetadataParameter.create({
            name: json.name,
            type: Metadata.from(json.type, dict),
            description: json.description,
            jsDocTags: json.jsDocTags,
        });
    }
    toJSON() {
        return {
            name: this.name,
            type: this.type.toJSON(),
            description: this.description,
            jsDocTags: this.jsDocTags,
        };
    }
}

export { MetadataParameter };
//# sourceMappingURL=MetadataParameter.mjs.map
