"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataParameter = void 0;
const Metadata_1 = require("./Metadata");
class MetadataParameter {
    constructor(props) {
        this.name = props.name;
        this.type = props.type;
        this.description = props.description;
        this.jsDocTags = props.jsDocTags;
        this.tsType = props.tsType;
    }
    /** @internal */
    static create(props) {
        return new MetadataParameter(props);
    }
    static from(json, dict) {
        return MetadataParameter.create({
            name: json.name,
            type: Metadata_1.Metadata.from(json.type, dict),
            description: json.description,
            jsDocTags: json.jsDocTags,
        });
    }
    toJSON() {
        return {
            name: this.name,
            type: this.type.toJSON(),
            description: this.description,
            jsDocTags: this.jsDocTags,
        };
    }
}
exports.MetadataParameter = MetadataParameter;
//# sourceMappingURL=MetadataParameter.js.map