"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataObjectType = void 0;
class MetadataObjectType {
    /* -----------------------------------------------------------
          CONSTRUCTORS
      ----------------------------------------------------------- */
    /** @ignore */
    constructor(props) {
        this.nullables = [];
        /** @internal */
        this.tagged_ = false;
        this.name = props.name;
        this.properties = props.properties;
        this.description = props.description;
        this.jsDocTags = props.jsDocTags;
        this.index = props.index;
        this.validated = props.validated;
        this.recursive = props.recursive;
        this.nullables = props.nullables.slice();
        this.tagged_ = false;
    }
    /** @internal */
    static create(props) {
        return new MetadataObjectType(props);
    }
    /** @internal */
    static _From_without_properties(obj) {
        return MetadataObjectType.create({
            name: obj.name,
            properties: [],
            description: obj.description,
            jsDocTags: obj.jsDocTags,
            index: obj.index,
            validated: false,
            recursive: obj.recursive,
            nullables: obj.nullables.slice(),
        });
    }
    isPlain(level = 0) {
        return (this.recursive === false &&
            this.properties.length < 10 &&
            this.properties.every((property) => property.key.isSoleLiteral() &&
                property.value.size() === 1 &&
                property.value.isRequired() === true &&
                property.value.nullable === false &&
                (property.value.atomics.length === 1 ||
                    (level < 1 &&
                        property.value.objects.length === 1 &&
                        property.value.objects[0].type.isPlain(level + 1)))));
    }
    isLiteral() {
        var _a;
        return ((_a = this.literal_) !== null && _a !== void 0 ? _a : (this.literal_ = (() => {
            if (this.recursive === true)
                return false;
            return (this.name === "__type" ||
                this.name === "__object" ||
                this.name.startsWith("__type.") ||
                this.name.startsWith("__object.") ||
                this.name.includes("readonly ["));
        })()));
    }
    toJSON() {
        return {
            name: this.name,
            properties: this.properties.map((property) => property.toJSON()),
            description: this.description,
            jsDocTags: this.jsDocTags,
            index: this.index,
            recursive: this.recursive,
            nullables: this.nullables.slice(),
        };
    }
}
exports.MetadataObjectType = MetadataObjectType;
/** @internal */
(function (MetadataObjectType) {
    MetadataObjectType.intersects = (x, y) => x.properties.some((prop) => y.properties.find((oppo) => prop.key.getName() === oppo.key.getName()) !== undefined);
    MetadataObjectType.covers = (x, y) => x.properties.length >= y.properties.length &&
        x.properties.every((prop) => y.properties.find((oppo) => prop.key.getName() === oppo.key.getName()) !== undefined);
})(MetadataObjectType || (exports.MetadataObjectType = MetadataObjectType = {}));
//# sourceMappingURL=MetadataObjectType.js.map