"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataFunction = void 0;
const Metadata_1 = require("./Metadata");
const MetadataParameter_1 = require("./MetadataParameter");
class MetadataFunction {
    /** @ignore */
    constructor(props) {
        this.parameters = props.parameters;
        this.output = props.output;
        this.async = props.async;
    }
    /** @internal */
    static create(props) {
        return new MetadataFunction(props);
    }
    static from(json, dict) {
        return MetadataFunction.create({
            parameters: json.parameters.map((p) => MetadataParameter_1.MetadataParameter.from(p, dict)),
            output: Metadata_1.Metadata.from(json.output, dict),
            async: json.async,
        });
    }
    toJSON() {
        return {
            parameters: this.parameters.map((p) => p.toJSON()),
            output: this.output.toJSON(),
            async: this.async,
        };
    }
}
exports.MetadataFunction = MetadataFunction;
//# sourceMappingURL=MetadataFunction.js.map