"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataAtomic = void 0;
class MetadataAtomic {
    /** @internal */
    constructor(props) {
        this.type = props.type;
        this.tags = props.tags;
    }
    static create(props) {
        return new MetadataAtomic(props);
    }
    static from(json) {
        return MetadataAtomic.create({
            type: json.type,
            tags: json.tags.map((row) => row.map((tag) => {
                var _a;
                return ({
                    target: tag.target,
                    name: tag.name,
                    kind: tag.kind,
                    value: typeof tag.value === "object" &&
                        ((_a = tag.value) === null || _a === void 0 ? void 0 : _a.type) === "bigint" &&
                        typeof tag.value.value === "string"
                        ? BigInt(tag.value.value)
                        : tag.value,
                    validate: tag.validate,
                    exclusive: tag.exclusive,
                    schema: tag.schema,
                });
            })),
        });
    }
    getName() {
        var _a;
        return ((_a = this.name_) !== null && _a !== void 0 ? _a : (this.name_ = getName(this)));
    }
    toJSON() {
        return {
            type: this.type,
            tags: this.tags.map((row) => row.map((tag) => ({
                target: tag.target,
                name: tag.name,
                kind: tag.kind,
                value: typeof tag.value === "bigint"
                    ? {
                        type: "bigint",
                        value: tag.value.toString(),
                    }
                    : tag.value,
                validate: tag.validate,
                exclusive: tag.exclusive,
                schema: tag.schema,
            }))),
        };
    }
}
exports.MetadataAtomic = MetadataAtomic;
const getName = (obj) => {
    if (obj.tags.length === 0)
        return obj.type;
    else if (obj.tags.length === 1) {
        const str = [obj.type, ...obj.tags[0].map((t) => t.name)].join(" & ");
        return `(${str})`;
    }
    const rows = obj.tags.map((row) => {
        const str = row.map((t) => t.name).join(" & ");
        return row.length === 1 ? str : `(${str})`;
    });
    return `(${obj.type} & (${rows.join(" | ")}))`;
};
//# sourceMappingURL=MetadataAtomic.js.map